/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.cache;

import io.polaris.core.cache.ICacheManager;
import io.polaris.core.service.StatefulServiceLoader;
import java.util.Optional;
import javax.annotation.Nullable;

public interface ICacheManagerFactory {
    public ICacheManager getCacheManager();

    @Nullable
    public static ICacheManagerFactory defaultCacheManagerFactory() {
        StatefulServiceLoader<ICacheManagerFactory> loader = StatefulServiceLoader.load(ICacheManagerFactory.class);
        return loader.service();
    }

    @Nullable
    public static ICacheManager defaultCacheManager() {
        return Optional.ofNullable(ICacheManagerFactory.defaultCacheManagerFactory()).map(ICacheManagerFactory::getCacheManager).orElse(null);
    }
}

