/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.classloader;

import io.polaris.core.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.function.BiFunction;

public class DynamicURLClassLoader
extends URLClassLoader {
    private final BiFunction<DynamicURLClassLoader, String, Class<?>> extension;

    public DynamicURLClassLoader(ClassLoader parent, URL[] urls) {
        this(parent, urls, null);
    }

    public DynamicURLClassLoader(ClassLoader parent, URL[] urls, BiFunction<DynamicURLClassLoader, String, Class<?>> extension) {
        super(urls, parent);
        this.extension = extension;
    }

    public DynamicURLClassLoader(URL[] urls) {
        this(urls, (BiFunction<DynamicURLClassLoader, String, Class<?>>)null);
    }

    public DynamicURLClassLoader(URL[] urls, BiFunction<DynamicURLClassLoader, String, Class<?>> extension) {
        super(urls);
        this.extension = extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = null;
            loadedClass = this.findLoadedClass(name);
            if (loadedClass == null && name.startsWith("java.")) {
                try {
                    loadedClass = Class.forName(name, false, this.getParent());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                try {
                    loadedClass = this.readClass(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                try {
                    if (this.extension != null) {
                        loadedClass = this.extension.apply(this, name);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                loadedClass = Class.forName(name, false, this.getParent());
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> readClass(String name) {
        try {
            URL url;
            InputStream in;
            Enumeration<URL> es = this.findResources(name.replace('.', '/') + ".class");
            do {
                if (!es.hasMoreElements()) return null;
            } while ((in = (url = es.nextElement()).openStream()) == null);
            try {
                Class<?> clazz;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                int i = in.read(buf);
                while (i != -1) {
                    bos.write(buf, 0, i);
                    i = in.read(buf);
                }
                byte[] bytes = bos.toByteArray();
                Class<?> clazz2 = clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz2;
            }
            finally {
                IO.close(in);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}

