/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compiler;

import io.polaris.core.compiler.MemoryJavaFileObject;
import io.polaris.core.io.IO;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.string.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.tools.JavaFileObject;

public class MemoryClassLoader
extends URLClassLoader {
    private static final ILogger log = ILoggers.of(MemoryClassLoader.class);
    private static final String classBytesCacheDir;
    private static final boolean classBytesCacheEnabled;
    private final Map<String, MemoryJavaFileObject> classes = new ConcurrentHashMap<String, MemoryJavaFileObject>();
    private final String classPath;
    private final Set<String> classPaths = new LinkedHashSet<String>();

    public MemoryClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.classPath = this.parseClassPath();
    }

    public MemoryClassLoader(ClassLoader parentClassLoader) {
        super(new URL[0], parentClassLoader);
        this.classPath = this.parseClassPath();
    }

    public static MemoryClassLoader getInstance() {
        return Holder.get(Thread.currentThread().getContextClassLoader());
    }

    public static MemoryClassLoader getInstance(ClassLoader parentClassLoader) {
        return Holder.get(parentClassLoader);
    }

    public Collection<JavaFileObject> files() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    static void writeMemoryClassBytesCacheFile(String className, byte[] bytes) {
        if (classBytesCacheEnabled) {
            try {
                File file = new File(classBytesCacheDir + "/" + className.replace(".", "/") + ".class");
                log.debug("\u7f13\u5b58\u52a8\u6001\u751f\u6210\u7c7b\u7684\u5b57\u8282\u7801\uff1a{}", file.getAbsolutePath());
                IO.writeBytes(file, bytes);
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] bytes;
        MemoryJavaFileObject file = this.classes.get(className);
        if (file != null && (bytes = file.getByteCode()) != null) {
            return this.defineClass(className, bytes, 0, bytes.length);
        }
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            return super.findClass(className);
        }
    }

    public void addIfAbsent(String className, byte[] classBytes) {
        this.addIfAbsent(className, new MemoryJavaFileObject(className, classBytes));
    }

    public void add(String className, byte[] classBytes) {
        this.add(className, new MemoryJavaFileObject(className, classBytes));
    }

    public void addIfAbsent(String className, MemoryJavaFileObject file) {
        MemoryJavaFileObject old = this.classes.putIfAbsent(className, file);
        if (old == null) {
            MemoryClassLoader.writeMemoryClassBytesCacheFile(className, file.getByteCode());
        }
    }

    public void add(String className, MemoryJavaFileObject file) {
        this.classes.put(className, file);
        MemoryClassLoader.writeMemoryClassBytesCacheFile(className, file.getByteCode());
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Nullable
    public byte[] getMemoryClassBytes(String name) {
        MemoryJavaFileObject file;
        String className = name;
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            className = name.substring(0, name.length() - JavaFileObject.Kind.CLASS.extension.length()).replace('/', '.');
        }
        if ((file = this.classes.get(className)) == null) {
            return null;
        }
        return file.getByteCode();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes;
        String className;
        MemoryJavaFileObject file;
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension) && (file = this.classes.get(className = name.substring(0, name.length() - JavaFileObject.Kind.CLASS.extension.length()).replace('/', '.'))) != null && (bytes = file.getByteCode()) != null) {
            return new ByteArrayInputStream(bytes);
        }
        return super.getResourceAsStream(name);
    }

    private String parseClassPath() {
        String sysPath;
        Package[] packages;
        StringBuilder classpath = new StringBuilder();
        Set<String> classPaths = this.classPaths;
        ClassLoader parent = this.getParent();
        if (parent != null && parent instanceof URLClassLoader && !"sun.misc.Launcher$AppClassLoader".equals(parent.getClass().getName())) {
            for (URL url : ((URLClassLoader)parent).getURLs()) {
                String path = url.getFile();
                classPaths.add(path);
            }
        }
        if ((packages = this.getPackages()) != null) {
            HashSet<String> resourcePrefix = new HashSet<String>();
            for (Package aPackage : packages) {
                String name = aPackage.getName();
                int i = name.indexOf(".");
                if (i > 0) {
                    name = name.substring(0, i);
                }
                resourcePrefix.add(name);
            }
            for (String prefix : resourcePrefix) {
                try {
                    Enumeration<URL> resources = this.getResources(prefix);
                    while (resources.hasMoreElements()) {
                        boolean match;
                        URL url = resources.nextElement();
                        String file = url.toString();
                        do {
                            match = false;
                            if ((file = file.replaceFirst("/+$", "")).startsWith("zip:")) {
                                file = file.substring("zip:".length());
                                match = true;
                            }
                            if (file.startsWith("jar:")) {
                                file = file.substring("jar:".length());
                                match = true;
                            }
                            if (file.startsWith("file:")) {
                                file = file.substring("file:".length());
                                match = true;
                            }
                            if (file.endsWith("!/" + prefix)) {
                                file = file.substring(0, file.length() - prefix.length() - 2);
                                match = true;
                                continue;
                            }
                            if (!file.endsWith("/" + prefix)) continue;
                            file = file.substring(0, file.length() - prefix.length() - 1);
                            match = true;
                        } while (match);
                        classPaths.add(file);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        if ((sysPath = System.getProperty("java.class.path")) != null) {
            String[] arr;
            for (String path : arr = sysPath.split(File.pathSeparator)) {
                if (!Strings.isNotBlank(path)) continue;
                classPaths.add(path);
            }
        }
        for (String path : classPaths) {
            classpath.append(path).append(File.pathSeparator);
        }
        return classpath.toString();
    }

    public Set<String> getClassPaths() {
        return Collections.unmodifiableSet(this.classPaths);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getClassPath(String ... paths) {
        StringBuilder classpath = new StringBuilder();
        for (String path : paths) {
            classpath.append(path).append(File.pathSeparator);
        }
        classpath.append(this.classPath);
        return classpath.toString();
    }

    static {
        String tmpdir = System.getProperty("java.class.bytes.tmpdir");
        if (Strings.isNotBlank(tmpdir)) {
            File dir = new File(tmpdir.trim());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            classBytesCacheDir = dir.getAbsolutePath();
            classBytesCacheEnabled = dir.exists();
        } else {
            classBytesCacheDir = null;
            classBytesCacheEnabled = false;
        }
    }

    private static final class Holder {
        private static final Map<ClassLoader, MemoryClassLoader> CACHE = new ConcurrentHashMap<ClassLoader, MemoryClassLoader>();

        private Holder() {
        }

        public static MemoryClassLoader get(ClassLoader classLoader) {
            classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            return CACHE.computeIfAbsent(classLoader, loader -> AccessController.doPrivileged(() -> new MemoryClassLoader((ClassLoader)loader)));
        }
    }
}

