/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compress;

import io.polaris.core.io.IO;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

public class Deflate
implements Closeable {
    private final InputStream source;
    private OutputStream target;
    private final boolean nowrap;

    public static Deflate of(InputStream source, OutputStream target, boolean nowrap) {
        return new Deflate(source, target, nowrap);
    }

    public Deflate(InputStream source, OutputStream target, boolean nowrap) {
        this.source = source;
        this.target = target;
        this.nowrap = nowrap;
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public Deflate deflate(int level) throws IOException {
        this.target = this.target instanceof DeflaterOutputStream ? (DeflaterOutputStream)this.target : new DeflaterOutputStream(this.target, new Deflater(level, this.nowrap));
        IO.copy(this.source, this.target);
        ((DeflaterOutputStream)this.target).finish();
        return this;
    }

    public Deflate inflate() throws IOException {
        this.target = this.target instanceof InflaterOutputStream ? (InflaterOutputStream)this.target : new InflaterOutputStream(this.target, new Inflater(this.nowrap));
        IO.copy(this.source, this.target);
        ((InflaterOutputStream)this.target).finish();
        return this;
    }

    @Override
    public void close() {
        IO.close(this.target);
        IO.close(this.source);
    }
}

