/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.PooledThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Executors {
    public static final int KEEP_ALIVE_TIME = 30000;
    public static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static RejectedExecutionHandler defaultRejectedPolicy = new ThreadPoolExecutor.CallerRunsPolicy();

    public static void setDefaultRejectedPolicy(RejectedExecutionHandler defaultRejectedPolicy) {
        Executors.defaultRejectedPolicy = defaultRejectedPolicy;
    }

    public static RejectedExecutionHandler getDefaultRejectedPolicy() {
        return defaultRejectedPolicy;
    }

    public static ThreadPoolExecutor create(int core, String threadNamePrefix) {
        return Executors.create(core, core, threadNamePrefix, true);
    }

    public static ThreadPoolExecutor create(int core, int max, String threadNamePrefix) {
        return Executors.create(core, max, threadNamePrefix, true);
    }

    public static ThreadPoolExecutor create(int core, String threadNamePrefix, boolean isDaemon) {
        return Executors.create(core, core, Executors.createDefaultBlockingQueue(), threadNamePrefix, isDaemon);
    }

    public static ThreadPoolExecutor create(int core, int max, String threadNamePrefix, boolean isDaemon) {
        return Executors.create(core, max, Executors.createDefaultBlockingQueue(), threadNamePrefix, isDaemon);
    }

    public static ThreadPoolExecutor create(int core, BlockingQueue<Runnable> blockingQueue, String threadNamePrefix, boolean isDaemon) {
        return new ThreadPoolExecutor(core, core, 30000L, KEEP_ALIVE_TIME_UNIT, blockingQueue, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ThreadPoolExecutor create(int core, int max, BlockingQueue<Runnable> blockingQueue, String threadNamePrefix, boolean isDaemon) {
        return new ThreadPoolExecutor(core, max, 30000L, KEEP_ALIVE_TIME_UNIT, blockingQueue, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ThreadPoolExecutor create(int core, ThreadFactory threadFactory) {
        return Executors.create(core, core, Executors.createDefaultBlockingQueue(), threadFactory);
    }

    public static ThreadPoolExecutor create(int core, int max, ThreadFactory threadFactory) {
        return Executors.create(core, max, Executors.createDefaultBlockingQueue(), threadFactory);
    }

    private static BlockingQueue<Runnable> createDefaultBlockingQueue() {
        return new LinkedBlockingQueue<Runnable>(1000);
    }

    public static ThreadPoolExecutor create(int core, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(core, core, 30000L, KEEP_ALIVE_TIME_UNIT, blockingQueue, threadFactory, defaultRejectedPolicy);
    }

    public static ThreadPoolExecutor create(int core, int max, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(core, max, 30000L, KEEP_ALIVE_TIME_UNIT, blockingQueue, threadFactory, defaultRejectedPolicy);
    }

    public static void shutdown(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

