/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.pool;

import io.polaris.core.collection.Iterables;
import io.polaris.core.concurrent.pool.ErrorRecord;
import io.polaris.core.concurrent.pool.ErrorRecords;
import io.polaris.core.concurrent.pool.RunnableState;
import io.polaris.core.concurrent.pool.RunnableStatistics;
import io.polaris.core.concurrent.pool.TransactionConsumer;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class RunnableDelegates {
    private static final ILogger log = ILoggers.of(RunnableDelegates.class);

    public static <E> Runnable createDelegate(RunnableState<E> pState, Consumer<E> pConsumer, AtomicReference<Consumer<ErrorRecords<E>>> rejectConsumerRef) {
        return () -> {
            block16: {
                RunnableState state = pState;
                Consumer consumer = pConsumer;
                RunnableStatistics statistics = state.runnableStatistics();
                state.incrementActiveCount();
                try {
                    if (statistics != null) {
                        while (state.hasNext()) {
                            Object data = state.next();
                            if (data == null) continue;
                            statistics.getTotal().incrementAndGet();
                            try {
                                consumer.accept(data);
                                statistics.getSuccess().incrementAndGet();
                            }
                            catch (Throwable e) {
                                statistics.getError().incrementAndGet();
                                try {
                                    Consumer rejectConsumer = (Consumer)rejectConsumerRef.get();
                                    if (rejectConsumer != null) {
                                        ErrorRecords errorRecords = new ErrorRecords(Iterables.asList(new ErrorRecord(data, e)), e);
                                        rejectConsumer.accept(errorRecords);
                                    }
                                }
                                catch (Throwable ex) {
                                    e.addSuppressed(ex);
                                }
                                log.error("\u5904\u7406\u5931\u8d25", e);
                            }
                            state.notifyFinished();
                        }
                        break block16;
                    }
                    while (state.hasNext()) {
                        Object data = state.next();
                        if (data == null) continue;
                        try {
                            consumer.accept(data);
                            state.notifyFinished();
                        }
                        catch (Throwable e) {
                            try {
                                Consumer rejectConsumer = (Consumer)rejectConsumerRef.get();
                                if (rejectConsumer != null) {
                                    ErrorRecords errorRecords = new ErrorRecords(Iterables.asList(new ErrorRecord(data, e)), e);
                                    rejectConsumer.accept(errorRecords);
                                }
                            }
                            catch (Throwable ex) {
                                e.addSuppressed(ex);
                            }
                            log.error("\u5904\u7406\u5931\u8d25", e);
                        }
                    }
                }
                finally {
                    state.decrementActiveCount();
                    state.notifyFinished();
                    log.trace("\u5904\u7406\u5b8c\u6210");
                }
            }
        };
    }

    public static <E, Resource> Runnable createDelegate(RunnableState<E> pState, TransactionConsumer<E, Resource> pConsumer, AtomicReference<Consumer<ErrorRecords<E>>> rejectConsumerRef) {
        return () -> {
            block33: {
                RunnableState state = pState;
                TransactionConsumer consumer = pConsumer;
                RunnableStatistics statistics = state.runnableStatistics();
                state.incrementActiveCount();
                Object resource = null;
                try {
                    int commitCount = consumer.commitCount();
                    if (commitCount <= 0) {
                        commitCount = 1000;
                    }
                    int total = 0;
                    int success = 0;
                    int error = 0;
                    int commit = 0;
                    ArrayList<ErrorRecord<ErrorRecord<Object>>> batchData = new ArrayList<ErrorRecord<ErrorRecord<Object>>>(commitCount);
                    resource = consumer.openResource();
                    while (state.hasNext()) {
                        Object data = state.next();
                        if (data == null) continue;
                        try {
                            ++total;
                            if (statistics != null) {
                                statistics.getTotal().incrementAndGet();
                            }
                            batchData.add(new ErrorRecord<Object>(data, null));
                            if (++commit >= commitCount) {
                                for (ErrorRecord errorRecord : batchData) {
                                    try {
                                        consumer.processData(resource, errorRecord.getData());
                                    }
                                    catch (Throwable e) {
                                        errorRecord.setError(e);
                                        throw e;
                                    }
                                }
                                consumer.commitResource(resource);
                                success += commit;
                                if (statistics != null) {
                                    statistics.getSuccess().addAndGet(commit);
                                }
                                log.trace("\u5904\u7406/\u63d0\u4ea4\u6210\u529f. total: {}, success: {}, error: {}", total, success, error);
                                commit = 0;
                                batchData = new ArrayList(commitCount);
                            }
                        }
                        catch (Throwable throwable) {
                            error += commit;
                            if (statistics != null) {
                                statistics.getError().addAndGet(commit);
                            }
                            commit = 0;
                            log.trace("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25. total: {}, success: {}, error: {}", total, success, error);
                            try {
                                consumer.rollbackResource(resource);
                            }
                            catch (Throwable throwable2) {
                                log.error("\u56de\u6eda\u5931\u8d25", throwable2);
                                throwable.addSuppressed(throwable2);
                            }
                            try {
                                Consumer consumer2 = (Consumer)rejectConsumerRef.get();
                                if (consumer2 != null) {
                                    ErrorRecords errorRecords = new ErrorRecords(batchData);
                                    errorRecords.setError(throwable);
                                    consumer2.accept(errorRecords);
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            batchData = new ArrayList(commitCount);
                            log.error("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25", throwable);
                        }
                        state.notifyFinished();
                    }
                    if (commit <= 0) break block33;
                    try {
                        for (ErrorRecord errorRecord : batchData) {
                            try {
                                consumer.processData(resource, errorRecord.getData());
                            }
                            catch (Throwable throwable) {
                                errorRecord.setError(throwable);
                                throw throwable;
                            }
                        }
                        consumer.commitResource(resource);
                        success += commit;
                        if (statistics != null) {
                            statistics.getSuccess().addAndGet(commit);
                        }
                        log.trace("\u5904\u7406/\u63d0\u4ea4\u6210\u529f. total: {}, success: {}, error: {}", total, success, error);
                    }
                    catch (Throwable e) {
                        error += commit;
                        if (statistics != null) {
                            statistics.getError().addAndGet(commit);
                        }
                        log.trace("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25. total: {}, success: {}, error: {}", total, success, error);
                        try {
                            consumer.rollbackResource(resource);
                        }
                        catch (Throwable throwable) {
                            log.error("\u56de\u6eda\u5931\u8d25", throwable);
                            e.addSuppressed(throwable);
                        }
                        try {
                            Consumer consumer3 = (Consumer)rejectConsumerRef.get();
                            if (consumer3 != null) {
                                ErrorRecords errorRecords = new ErrorRecords(batchData);
                                errorRecords.setError(e);
                                consumer3.accept(errorRecords);
                            }
                        }
                        catch (Throwable throwable) {
                            e.addSuppressed(throwable);
                        }
                        log.error("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25", e);
                    }
                }
                catch (Throwable e) {
                    log.error("", e);
                }
                finally {
                    log.trace("\u5904\u7406\u5b8c\u6210");
                    state.decrementActiveCount();
                    state.notifyFinished();
                    consumer.closeResource(resource);
                }
            }
        };
    }
}

