/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.ArrayConverter;
import io.polaris.core.converter.BeanConverter;
import io.polaris.core.converter.CollectionConverter;
import io.polaris.core.converter.Converter;
import io.polaris.core.converter.Converters;
import io.polaris.core.converter.EnumConverter;
import io.polaris.core.converter.MapConverter;
import io.polaris.core.converter.support.AtomicBooleanConverter;
import io.polaris.core.converter.support.AtomicIntegerArrayConverter;
import io.polaris.core.converter.support.AtomicLongArrayConverter;
import io.polaris.core.converter.support.AtomicReferenceConverter;
import io.polaris.core.converter.support.BooleanConverter;
import io.polaris.core.converter.support.CalendarConverter;
import io.polaris.core.converter.support.CharacterConverter;
import io.polaris.core.converter.support.CharsetConverter;
import io.polaris.core.converter.support.ClassConverter;
import io.polaris.core.converter.support.CurrencyConverter;
import io.polaris.core.converter.support.DateConverter;
import io.polaris.core.converter.support.DurationConverter;
import io.polaris.core.converter.support.LocaleConverter;
import io.polaris.core.converter.support.NumberConverter;
import io.polaris.core.converter.support.OptionalConverter;
import io.polaris.core.converter.support.PathConverter;
import io.polaris.core.converter.support.PeriodConverter;
import io.polaris.core.converter.support.PrimitiveConverter;
import io.polaris.core.converter.support.ReferenceConverter;
import io.polaris.core.converter.support.StackTraceElementConverter;
import io.polaris.core.converter.support.StringConverter;
import io.polaris.core.converter.support.TemporalAccessorConverter;
import io.polaris.core.converter.support.TimeZoneConverter;
import io.polaris.core.converter.support.URIConverter;
import io.polaris.core.converter.support.URLConverter;
import io.polaris.core.converter.support.UUIDConverter;
import io.polaris.core.converter.support.UlidConverter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.service.Service;
import io.polaris.core.service.ServiceLoader;
import io.polaris.core.ulid.Ulid;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nullable;

public class ConverterRegistry {
    private static final ILogger log = ILoggers.of(ConverterRegistry.class);
    private static final Map<Type, Converter<?>> standardConverters = new ConcurrentHashMap();
    private static final Map<Type, Converter<?>> serviceConverters = new ConcurrentHashMap();
    private final Map<Type, Converter<?>> customConverters = new ConcurrentHashMap();

    private static void initStandard() {
        standardConverters.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        standardConverters.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        standardConverters.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        standardConverters.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        standardConverters.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        standardConverters.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        standardConverters.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        standardConverters.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        standardConverters.put((Type)((Object)Number.class), (Converter<?>)new NumberConverter<Number>(Number.class));
        standardConverters.put((Type)((Object)Integer.class), (Converter<?>)new NumberConverter<Integer>(Integer.class));
        standardConverters.put((Type)((Object)AtomicInteger.class), (Converter<?>)new NumberConverter<AtomicInteger>(AtomicInteger.class));
        standardConverters.put((Type)((Object)Long.class), (Converter<?>)new NumberConverter<Long>(Long.class));
        standardConverters.put((Type)((Object)LongAdder.class), (Converter<?>)new NumberConverter<LongAdder>(LongAdder.class));
        standardConverters.put((Type)((Object)AtomicLong.class), (Converter<?>)new NumberConverter<AtomicLong>(AtomicLong.class));
        standardConverters.put((Type)((Object)Byte.class), (Converter<?>)new NumberConverter<Byte>(Byte.class));
        standardConverters.put((Type)((Object)Short.class), (Converter<?>)new NumberConverter<Short>(Short.class));
        standardConverters.put((Type)((Object)Float.class), (Converter<?>)new NumberConverter<Float>(Float.class));
        standardConverters.put((Type)((Object)Double.class), (Converter<?>)new NumberConverter<Double>(Double.class));
        standardConverters.put((Type)((Object)DoubleAdder.class), (Converter<?>)new NumberConverter<DoubleAdder>(DoubleAdder.class));
        standardConverters.put((Type)((Object)BigDecimal.class), (Converter<?>)new NumberConverter<BigDecimal>(BigDecimal.class));
        standardConverters.put((Type)((Object)BigInteger.class), (Converter<?>)new NumberConverter<BigInteger>(BigInteger.class));
        standardConverters.put((Type)((Object)Character.class), new CharacterConverter());
        standardConverters.put((Type)((Object)Boolean.class), new BooleanConverter());
        standardConverters.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        standardConverters.put((Type)((Object)CharSequence.class), new StringConverter());
        standardConverters.put((Type)((Object)String.class), new StringConverter());
        standardConverters.put((Type)((Object)URI.class), new URIConverter());
        standardConverters.put((Type)((Object)URL.class), new URLConverter());
        standardConverters.put((Type)((Object)Calendar.class), new CalendarConverter());
        standardConverters.put((Type)((Object)Date.class), (Converter<?>)new DateConverter<Date>(Date.class));
        standardConverters.put((Type)((Object)java.sql.Date.class), (Converter<?>)new DateConverter<java.sql.Date>(java.sql.Date.class));
        standardConverters.put((Type)((Object)Time.class), (Converter<?>)new DateConverter<Time>(Time.class));
        standardConverters.put((Type)((Object)Timestamp.class), (Converter<?>)new DateConverter<Timestamp>(Timestamp.class));
        standardConverters.put((Type)((Object)TemporalAccessor.class), (Converter<?>)new TemporalAccessorConverter<Instant>(Instant.class));
        standardConverters.put((Type)((Object)Instant.class), (Converter<?>)new TemporalAccessorConverter<Instant>(Instant.class));
        standardConverters.put((Type)((Object)LocalDateTime.class), (Converter<?>)new TemporalAccessorConverter<LocalDateTime>(LocalDateTime.class));
        standardConverters.put((Type)((Object)LocalDate.class), (Converter<?>)new TemporalAccessorConverter<LocalDate>(LocalDate.class));
        standardConverters.put((Type)((Object)LocalTime.class), (Converter<?>)new TemporalAccessorConverter<LocalTime>(LocalTime.class));
        standardConverters.put((Type)((Object)ZonedDateTime.class), (Converter<?>)new TemporalAccessorConverter<ZonedDateTime>(ZonedDateTime.class));
        standardConverters.put((Type)((Object)OffsetDateTime.class), (Converter<?>)new TemporalAccessorConverter<OffsetDateTime>(OffsetDateTime.class));
        standardConverters.put((Type)((Object)OffsetTime.class), (Converter<?>)new TemporalAccessorConverter<OffsetTime>(OffsetTime.class));
        standardConverters.put((Type)((Object)DayOfWeek.class), (Converter<?>)new TemporalAccessorConverter<DayOfWeek>(DayOfWeek.class));
        standardConverters.put((Type)((Object)Month.class), (Converter<?>)new TemporalAccessorConverter<Month>(Month.class));
        standardConverters.put((Type)((Object)MonthDay.class), (Converter<?>)new TemporalAccessorConverter<MonthDay>(MonthDay.class));
        standardConverters.put((Type)((Object)Year.class), (Converter<?>)new TemporalAccessorConverter<Year>(Year.class));
        standardConverters.put((Type)((Object)YearMonth.class), (Converter<?>)new TemporalAccessorConverter<YearMonth>(YearMonth.class));
        standardConverters.put((Type)((Object)Period.class), new PeriodConverter());
        standardConverters.put((Type)((Object)ChronoPeriod.class), new PeriodConverter());
        standardConverters.put((Type)((Object)Duration.class), new DurationConverter());
        standardConverters.put((Type)((Object)WeakReference.class), (Converter<?>)new ReferenceConverter<WeakReference>(WeakReference.class));
        standardConverters.put((Type)((Object)SoftReference.class), (Converter<?>)new ReferenceConverter<SoftReference>(SoftReference.class));
        standardConverters.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        standardConverters.put((Type)((Object)AtomicIntegerArray.class), new AtomicIntegerArrayConverter());
        standardConverters.put((Type)((Object)AtomicLongArray.class), new AtomicLongArrayConverter());
        standardConverters.put((Type)((Object)Class.class), new ClassConverter());
        standardConverters.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        standardConverters.put((Type)((Object)Locale.class), new LocaleConverter());
        standardConverters.put((Type)((Object)Charset.class), new CharsetConverter());
        standardConverters.put((Type)((Object)Path.class), new PathConverter());
        standardConverters.put((Type)((Object)Currency.class), new CurrencyConverter());
        standardConverters.put((Type)((Object)UUID.class), new UUIDConverter());
        standardConverters.put((Type)((Object)Ulid.class), new UlidConverter());
        standardConverters.put((Type)((Object)StackTraceElement.class), new StackTraceElementConverter());
        standardConverters.put((Type)((Object)Optional.class), new OptionalConverter());
    }

    private static void loadServices() {
        for (Service<Converter> service : ServiceLoader.of(Converter.class)) {
            try {
                Class<Converter> converterClass = service.getServiceClass();
                Converter converter = service.newInstance();
                Type actualType = JavaType.of(converterClass).getActualType(Converter.class, 0);
                serviceConverters.putIfAbsent(actualType, converter);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public <T> Converter<T> getConverter(Type type) {
        Converter<?> converter = this.customConverters.get(type);
        if (converter != null) {
            return converter;
        }
        converter = serviceConverters.get(type);
        if (converter != null) {
            return converter;
        }
        converter = standardConverters.get(type);
        return converter;
    }

    public <T> Converter<T> getConverterOrDefault(Type type, Converter<T> defaults) {
        Converter<T> converter = this.getConverter(type);
        return converter != null ? converter : defaults;
    }

    public void addConvert(Type type, Class<? extends Converter<?>> converterClass) {
        this.addConvert(type, Reflects.newInstanceIfPossible(converterClass));
    }

    public void addConvert(Type type, Converter<?> converter) {
        this.customConverters.put(type, converter);
    }

    public <T> T convert(Type type, Type valueType, Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (type instanceof TypeRef) {
            type = ((TypeRef)((Object)type)).getType();
            return this.convert(type, valueType, value, defaultValue);
        }
        JavaType sourceJavaType = JavaType.of(valueType);
        if (!sourceJavaType.isInstance(value)) {
            throw new IllegalArgumentException();
        }
        JavaType targetJavaType = JavaType.of(type);
        valueType = sourceJavaType.getRawType();
        if (valueType == (type = targetJavaType.getRawType())) {
            return (T)value;
        }
        Class<T[]> clazz = targetJavaType.getRawClass();
        if (type instanceof Class && clazz.isInstance(value)) {
            return (T)value;
        }
        Converter<T> converter = this.getConverter(type);
        if (converter != null) {
            return converter.convertOrDefault(valueType, value, defaultValue);
        }
        if (clazz.isEnum()) {
            return new EnumConverter<T>(targetJavaType.getRawClass()).convertOrDefault(valueType, value, defaultValue);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            CollectionConverter collectionConverter = new CollectionConverter(type);
            return (T)collectionConverter.convertOrDefault(valueType, value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            MapConverter mapConverter = new MapConverter(type);
            return (T)mapConverter.convertOrDefault(valueType, value, (Map)defaultValue);
        }
        if (clazz.isArray()) {
            ArrayConverter<T> arrayConverter = new ArrayConverter<T>(clazz);
            return arrayConverter.convertOrDefault(valueType, value, defaultValue);
        }
        if (Beans.isBeanClass(clazz)) {
            return new BeanConverter<T>(type).convertOrDefault(valueType, value, defaultValue);
        }
        if (type instanceof Class) {
            return Converters.convertByPropertyEditor((Class)type, value, defaultValue);
        }
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        return (T)clazz.cast(value);
    }

    public <T> T convert(Type type, Type valueType, Object value) {
        return this.convert(type, valueType, value, null);
    }

    public <T> T convert(Type type, Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return this.convert(type, value.getClass(), value, defaultValue);
    }

    public <T> T convert(Type type, Object value) {
        if (value == null) {
            return null;
        }
        return this.convert(type, value, null);
    }

    public <T> T convertQuietly(Type type, Type valueType, Object value, T defaultValue) {
        try {
            return this.convert(type, valueType, value, defaultValue);
        }
        catch (Exception e) {
            log.warn("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a{}", e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(e.getMessage(), e);
            }
            return defaultValue;
        }
    }

    public <T> T convertQuietly(Type type, Type valueType, Object value) {
        return this.convertQuietly(type, valueType, value, null);
    }

    public <T> T convertQuietly(Type type, Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return this.convertQuietly(type, value.getClass(), value, defaultValue);
    }

    public <T> T convertQuietly(Type type, Object value) {
        if (value == null) {
            return null;
        }
        return this.convertQuietly(type, value.getClass(), value, null);
    }

    static {
        ConverterRegistry.initStandard();
        ConverterRegistry.loadServices();
    }
}

