/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.AbstractConverter;
import io.polaris.core.converter.ConversionException;
import io.polaris.core.converter.Converters;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.copier.Copiers;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.service.StatefulServiceLoader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class MapConverter<K, V>
extends AbstractConverter<Map<K, V>> {
    private final JavaType<Map<K, V>> mapType;
    private final JavaType<K> keyType;
    private final JavaType<V> valueType;

    public MapConverter(JavaType<Map<K, V>> mapType) {
        this(mapType, JavaType.of(mapType.getActualType(Map.class, 0)), JavaType.of(mapType.getActualType(Map.class, 1)));
    }

    public MapConverter(Type mapType) {
        this(JavaType.of(mapType));
    }

    public MapConverter(JavaType<Map<K, V>> mapType, JavaType<K> keyType, JavaType<V> valueType) {
        this.mapType = mapType;
        this.keyType = keyType == null ? JavaType.of(Object.class) : keyType;
        this.valueType = valueType == null ? JavaType.of(Object.class) : valueType;
    }

    @Override
    public JavaType<Map<K, V>> getTargetType() {
        return this.mapType;
    }

    @Override
    protected <S> Map<K, V> doConvert(S value, JavaType<Map<K, V>> targetType, JavaType<S> sourceType) {
        Optional<JsonSerializer> optional;
        if (this.mapType.getRawClass().isAssignableFrom(sourceType.getRawClass())) {
            Type sourceValueType;
            boolean matchKeyType = false;
            boolean matchValueType = false;
            Type sourceKeyType = sourceType.getActualType(Map.class, 0);
            if (sourceKeyType instanceof Class) {
                if (this.keyType.getRawClass().isAssignableFrom((Class)sourceKeyType)) {
                    matchKeyType = true;
                }
            } else if (this.keyType.getRawType() == sourceKeyType) {
                matchKeyType = true;
            }
            if ((sourceValueType = sourceType.getActualType(Map.class, 1)) instanceof Class) {
                if (this.valueType.getRawClass().isAssignableFrom((Class)sourceValueType)) {
                    matchValueType = true;
                }
            } else if (this.valueType.getRawType() == sourceValueType) {
                matchValueType = true;
            }
            if (matchKeyType && matchValueType) {
                return (Map)value;
            }
        }
        if (value instanceof Map) {
            HashMap map;
            try {
                map = (HashMap)Reflects.newInstanceIfPossible(Types.getClass(this.mapType));
                if (map == null) {
                    map = new HashMap();
                }
            }
            catch (Exception e) {
                map = new HashMap();
            }
            this.convertMapToMap((Map)value, map);
            return map;
        }
        if (Beans.isBeanClass(value.getClass())) {
            LinkedHashMap tmp = Copiers.copy(value, new LinkedHashMap(), CopyOptions.create().ignoreNull(false));
            return this.doConvert(tmp, (JavaType)targetType, JavaType.of(new TypeRef<LinkedHashMap<String, Object>>(){}));
        }
        if (value instanceof CharSequence && (optional = StatefulServiceLoader.load(JsonSerializer.class).optionalService()).isPresent()) {
            String json = value.toString();
            return (Map)optional.get().deserialize(json, targetType.getRawType());
        }
        throw new ConversionException("\u6e90\u5bf9\u8c61\u7c7b\u578b\u4e0d\u652f\u6301");
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<K, V> targetMap) {
        srcMap.forEach((key, value) -> targetMap.put(Converters.convert(this.keyType, key), Converters.convert(this.valueType, value)));
    }
}

