/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import java.util.Map;

public class StackTraceElementConverter
extends AbstractSimpleConverter<StackTraceElement> {
    private final JavaType<StackTraceElement> targetType = JavaType.of(StackTraceElement.class);

    @Override
    public JavaType<StackTraceElement> getTargetType() {
        return this.targetType;
    }

    @Override
    protected StackTraceElement doConvert(Object value, JavaType<StackTraceElement> targetType) {
        if (value instanceof Map) {
            Map map = (Map)value;
            Object value4 = map.get("className");
            String declaringClass = (String)Converters.convertQuietly(String.class, value4);
            Object value3 = map.get("methodName");
            String methodName = (String)Converters.convertQuietly(String.class, value3);
            Object value2 = map.get("fileName");
            String fileName = (String)Converters.convertQuietly(String.class, value2);
            Object value1 = map.get("lineNumber");
            Integer lineNumber = (Integer)Converters.convertQuietly(Integer.class, value1);
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber == null ? 0 : lineNumber);
        }
        return null;
    }
}

