/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.asymmetric;

import io.polaris.core.crypto.Ciphers;
import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.IDecryptor;
import io.polaris.core.crypto.IEncryptor;
import io.polaris.core.crypto.asymmetric.AsymmetricAlgorithm;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class Asymmetric {
    private final String algorithm;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private IEncryptor encryptor;
    private IDecryptor decryptor;

    public Asymmetric(AsymmetricAlgorithm algorithm) {
        this(algorithm.code(), CryptoKeys.generateKeyPair(algorithm.code()));
    }

    public Asymmetric(AsymmetricAlgorithm algorithm, KeyPair keyPair) {
        this(algorithm.code(), keyPair.getPrivate(), keyPair.getPublic());
    }

    public Asymmetric(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.code(), privateKey, publicKey);
    }

    public Asymmetric(String algorithm) {
        this(algorithm, CryptoKeys.generateKeyPair(algorithm));
    }

    public Asymmetric(String algorithm, KeyPair keyPair) {
        this(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Asymmetric(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.algorithm = algorithm;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public IDecryptor getDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = Ciphers.getDecryptor(this.algorithm, this.privateKey);
        }
        return this.decryptor;
    }

    public IEncryptor getEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = Ciphers.getEncryptor(this.algorithm, this.publicKey);
        }
        return this.encryptor;
    }

    public Asymmetric encryptUpdate(byte[] data) {
        this.getEncryptor().update(data);
        return this;
    }

    public byte[] encrypt(byte[] data) {
        return this.getEncryptor().encrypt(data);
    }

    public Asymmetric decryptUpdate(byte[] data) {
        this.getDecryptor().update(data);
        return this;
    }

    public byte[] decrypt(byte[] data) {
        return this.getDecryptor().decrypt(data);
    }
}

