/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.otp;

import io.polaris.core.crypto.otp.OneTimePasswordGenerator;
import io.polaris.core.crypto.otp.OtpHmacHashAlgorithm;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;

public class TimeBasedOneTimePasswordGenerator {
    private final OneTimePasswordGenerator otp;
    private final Duration timeStep;

    public TimeBasedOneTimePasswordGenerator() {
        this(Duration.ofSeconds(30L));
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep) {
        this(timeStep, 6);
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep, int length) {
        this(timeStep, length, OtpHmacHashAlgorithm.HmacSHA1);
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep, int length, OtpHmacHashAlgorithm algorithm) {
        this.otp = new OneTimePasswordGenerator(length, algorithm);
        this.timeStep = timeStep;
    }

    private long toStepData(Instant timestamp) {
        return timestamp.toEpochMilli() / this.timeStep.toMillis();
    }

    private long toStepData(long timestamp) {
        return timestamp / this.timeStep.toMillis();
    }

    public boolean verify(Key key, Instant timestamp, int code) {
        return this.verify(key, timestamp.toEpochMilli(), code);
    }

    public boolean verify(Key key, long timestamp, int code) {
        long data = this.toStepData(timestamp);
        for (int i = -1; i <= 1; ++i) {
            int generated = this.otp.generate(key, data + (long)i);
            if (generated != code) continue;
            return true;
        }
        return false;
    }

    public boolean verify(String key, Instant timestamp, int code) {
        return this.verify(key, timestamp.toEpochMilli(), code);
    }

    public boolean verify(String key, long timestamp, int code) {
        long data = this.toStepData(timestamp);
        for (int i = -1; i <= 1; ++i) {
            int generated = this.otp.generate(key, data + (long)i);
            if (generated != code) continue;
            return true;
        }
        return false;
    }

    public int generate(Key key, Instant timestamp) {
        return this.otp.generate(key, this.toStepData(timestamp));
    }

    public int generate(Key key, long timestamp) {
        return this.otp.generate(key, this.toStepData(timestamp));
    }

    public int generate(String key, Instant timestamp) {
        return this.otp.generate(key, this.toStepData(timestamp));
    }

    public int generate(String key, long timestamp) {
        return this.otp.generate(key, this.toStepData(timestamp));
    }

    public String generateString(Key key, Instant timestamp) {
        return this.otp.generateString(key, this.toStepData(timestamp));
    }

    public String generateString(Key key, long timestamp) {
        return this.otp.generateString(key, this.toStepData(timestamp));
    }

    public String generateString(String key, Instant timestamp) {
        return this.otp.generateString(key, this.toStepData(timestamp));
    }

    public String generateString(String key, long timestamp) {
        return this.otp.generateString(key, this.toStepData(timestamp));
    }

    public String generateKeyString() {
        return this.otp.generateKeyString();
    }

    public String generateKeyString(int size) {
        return this.otp.generateKeyString(size);
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }

    public int getLength() {
        return this.otp.getLength();
    }

    public String getAlgorithm() {
        return this.otp.getAlgorithm();
    }
}

