/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data;

import io.polaris.core.assertion.Arguments;
import io.polaris.core.concurrent.PooledThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class BatchDataCollector<E> {
    private final AtomicLong lastTime;
    private final ArrayBlockingQueue<E> buffer;
    private final int maxStoreSize;
    private final long maxStoreNanos;
    private final Consumer<List<E>> consumer;
    private ScheduledExecutorService scheduler;

    public BatchDataCollector(int maxStoreSize, long maxStoreTime, TimeUnit timeUnit, Consumer<List<E>> consumer) {
        this(maxStoreSize, timeUnit.toNanos(maxStoreTime), consumer);
    }

    public BatchDataCollector(int maxStoreSize, long maxStoreNanos, Consumer<List<E>> consumer) {
        Arguments.isTrue(maxStoreSize > 0, "maxStoreSize must be greater than 0");
        Arguments.isTrue(maxStoreNanos > 0L, "maxStoreNanos must be greater than 0");
        this.maxStoreNanos = maxStoreNanos;
        this.maxStoreSize = maxStoreSize;
        this.consumer = consumer;
        this.buffer = new ArrayBlockingQueue(maxStoreSize);
        this.lastTime = new AtomicLong(System.nanoTime());
    }

    public int getMaxStoreSize() {
        return this.maxStoreSize;
    }

    public long getMaxStoreNanos() {
        return this.maxStoreNanos;
    }

    public Consumer<List<E>> getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startScheduler() {
        if (this.consumer == null) {
            return false;
        }
        if (this.scheduler != null) {
            return false;
        }
        BatchDataCollector batchDataCollector = this;
        synchronized (batchDataCollector) {
            ScheduledExecutorService scheduler;
            if (this.scheduler != null) {
                return false;
            }
            this.scheduler = scheduler = Executors.newScheduledThreadPool(1, new PooledThreadFactory("BatchDataCollector"));
            scheduler.scheduleAtFixedRate(this::flush, this.maxStoreNanos, this.maxStoreNanos, TimeUnit.NANOSECONDS);
            return true;
        }
    }

    public void collect(E datum) {
        this.collect(Collections.singletonList(datum), this.consumer);
    }

    public void collect(E datum, Consumer<List<E>> consumer) {
        this.collect(Collections.singletonList(datum), consumer);
    }

    public void collect(Iterable<E> data) {
        this.collect(data, this.consumer);
    }

    public void collect(Iterable<E> data, Consumer<List<E>> consumer) {
        boolean expired;
        if (consumer == null) {
            throw new IllegalStateException("\u6570\u636e\u6d88\u8d39\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (E datum : data) {
            while (!this.buffer.offer(datum)) {
                this.flush(consumer);
            }
        }
        long now = System.nanoTime();
        boolean bl = expired = now - this.lastTime.get() > this.maxStoreNanos;
        if (expired) {
            this.flush(consumer);
        }
    }

    public void flush() {
        this.flush(this.consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Consumer<List<E>> consumer) {
        if (consumer == null) {
            throw new IllegalStateException("\u6570\u636e\u6d88\u8d39\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int size = this.buffer.size();
        ArrayList list = new ArrayList(size);
        try {
            this.buffer.drainTo(list);
            if (!list.isEmpty()) {
                consumer.accept(list);
            }
        }
        finally {
            this.lastTime.set(System.nanoTime());
        }
    }
}

