/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data;

import io.polaris.core.data.buffer.BufferChannel;
import io.polaris.core.data.buffer.BufferStrategy;
import io.polaris.core.data.consumer.ConsumeDriver;
import io.polaris.core.data.consumer.IBulkConsumerDriver;
import io.polaris.core.data.consumer.IConsumer;
import io.polaris.core.data.consumer.IConsumerDriver;
import io.polaris.core.data.partition.IDataPartitioner;
import io.polaris.core.data.partition.SimpleRollingPartitioner;

public class DataCarrier<T> {
    private BufferChannel<T> channel;
    private IConsumerDriver<T> driver;
    private String name;

    public DataCarrier(int bufferCount, int bufferSize) {
        this("DEFAULT", bufferCount, bufferSize);
    }

    public DataCarrier(String name, int bufferCount, int bufferSize) {
        this(name, bufferCount, bufferSize, BufferStrategy.BLOCKING);
    }

    public DataCarrier(int bufferCount, int bufferSize, BufferStrategy strategy) {
        this("DEFAULT", bufferCount, bufferSize, strategy);
    }

    public DataCarrier(String name, int bufferCount, int bufferSize, BufferStrategy strategy) {
        this(name, bufferCount, bufferSize, strategy, new SimpleRollingPartitioner());
    }

    public DataCarrier(String name, int bufferCount, int bufferSize, BufferStrategy strategy, IDataPartitioner<T> partitioner) {
        this.name = name;
        this.channel = new BufferChannel<T>(bufferCount, bufferSize, partitioner, strategy);
    }

    public boolean produce(T data) {
        if (this.driver != null && !this.driver.isRunning(this.channel)) {
            return false;
        }
        return this.channel.produce(data);
    }

    public DataCarrier<T> consume(IConsumer<T> consumer, int num) {
        return this.consume(consumer, num, 20L);
    }

    public DataCarrier<T> consume(IConsumer<T> consumer, int num, long thinkTime) {
        if (this.driver != null) {
            this.driver.close(this.channel);
        }
        this.driver = new ConsumeDriver<T>(this.name, this.channel, consumer, num, thinkTime);
        this.driver.begin(this.channel);
        return this;
    }

    public DataCarrier<T> consume(IBulkConsumerDriver<T> consumerDriver, IConsumer<T> consumer) {
        this.driver = consumerDriver;
        consumerDriver.add(this.channel, consumer);
        this.driver.begin(this.channel);
        return this;
    }

    public DataCarrier<T> setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.channel.setPartitioner(dataPartitioner);
        return this;
    }

    public DataCarrier<T> setMaxRetryCount(int maxRetryCount) {
        this.channel.setMaxRetryCount(maxRetryCount);
        return this;
    }

    public BufferChannel<T> getChannel() {
        return this.channel;
    }

    public void shutdown() {
        if (this.driver != null) {
            this.driver.close(this.channel);
        }
    }
}

