/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data.consumer;

import io.polaris.core.data.buffer.IQueueBuffer;
import io.polaris.core.data.consumer.IConsumer;
import java.util.ArrayList;
import java.util.List;

public class ConsumerThread<T>
extends Thread {
    private volatile boolean running = false;
    private final IConsumer<T> consumer;
    private final List<IQueueBuffer<T>> queueBuffers = new ArrayList<IQueueBuffer<T>>(1);
    private final long thinkTime;

    ConsumerThread(String name, IConsumer<T> consumer, long thinkTime) {
        super(name);
        this.consumer = consumer;
        this.thinkTime = thinkTime;
    }

    void addSource(IQueueBuffer<T> sourceBuffer) {
        this.queueBuffers.add(sourceBuffer);
    }

    @Override
    public void run() {
        this.running = true;
        ArrayList consumeList = new ArrayList(1500);
        while (this.running) {
            if (this.consume(consumeList)) continue;
            try {
                Thread.sleep(this.thinkTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.consume(consumeList);
        this.consumer.onExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean consume(List<T> consumeList) {
        for (IQueueBuffer<T> sourceBuffer : this.queueBuffers) {
            sourceBuffer.drainTo(consumeList);
        }
        if (!consumeList.isEmpty()) {
            try {
                this.consumer.consume(consumeList);
            }
            catch (Throwable t) {
                this.consumer.onError(consumeList, t);
            }
            finally {
                consumeList.clear();
            }
            return true;
        }
        return false;
    }

    void shutdown() {
        this.running = false;
    }
}

