/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.DelegateEnv;
import io.polaris.core.env.MapWrapper;
import io.polaris.core.env.PropertiesWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public interface Env {
    default public String name() {
        return null;
    }

    default public void set(String key, String value) {
    }

    default public void remove(String key) {
    }

    default public String get(String key, String defaultValue) {
        String val = this.get(key);
        return val == null ? defaultValue : val;
    }

    public String get(String var1);

    public Set<String> keys();

    default public Properties asProperties() {
        Properties properties = new Properties();
        for (String key : this.keys()) {
            properties.setProperty(key, this.get(key));
        }
        return properties;
    }

    default public Map<String, String> asMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : this.keys()) {
            properties.put(key, this.get(key));
        }
        return properties;
    }

    public static Env wrap(Properties properties) {
        return new PropertiesWrapper(properties);
    }

    public static Env wrap(String name, Properties properties) {
        return new PropertiesWrapper(name, properties);
    }

    public static Env wrap(Map<String, String> properties) {
        return new MapWrapper(properties);
    }

    public static Env wrap(String name, Map<String, String> properties) {
        return new MapWrapper(name, properties);
    }

    public static DelegateEnv delegate(Env properties) {
        return new DelegateEnv(properties.name(), properties);
    }

    public static DelegateEnv delegate(String name, Env properties) {
        return new DelegateEnv(name, properties);
    }
}

