/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.err;

import io.polaris.core.err.IErrorCode;
import io.polaris.core.err.UncheckedException;
import io.polaris.core.msg.MessageResources;
import io.polaris.core.string.Strings;

public class MessageException
extends UncheckedException
implements IErrorCode {
    private static final long serialVersionUID = 1L;
    private String code;
    private String message;

    public MessageException() {
    }

    public MessageException(String message) {
        super(message);
    }

    public MessageException(String code, String message) {
        super(message);
        this.withCode(code, message);
    }

    public MessageException(Throwable cause) {
        super(cause);
        this.fetchCode(null, cause, null);
    }

    public MessageException(Throwable cause, String message) {
        super(message, cause);
        this.fetchCode(null, cause, message);
    }

    public MessageException(Throwable cause, String code, String message) {
        super(message, cause);
        this.fetchCode(code, cause, message);
    }

    public MessageException(Throwable cause, boolean enableSuppression, boolean writableStackTrace, String code, String message) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.fetchCode(code, cause, message);
    }

    private void fetchCode(String code, Throwable cause, String message) {
        if (code == null || code.trim().length() == 0) {
            if (cause instanceof IErrorCode) {
                this.withCode(((IErrorCode)((Object)cause)).getCode(), Strings.coalesce(message, cause.getMessage(), code));
            }
        } else {
            this.withCode(code, Strings.coalesce(message, cause == null ? null : cause.getMessage(), code));
        }
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public MessageException withCode(String code) {
        this.withCode(code, this.message);
        return this;
    }

    public MessageException withCode(String code, String defaultMessage) {
        this.code = code;
        if (code != null && code.length() > 0) {
            this.message = MessageResources.getDefaultMessageResource().getMessageOrDefault(code, defaultMessage, new Object[0]);
        }
        return this;
    }

    public MessageException withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String getMessage() {
        return this.message != null && this.message.length() > 0 ? this.message : super.getMessage();
    }

    public static MessageException of(Throwable t) {
        if (t == null) {
            return new MessageException();
        }
        if (t instanceof MessageException) {
            return (MessageException)t;
        }
        while (t.getCause() != null) {
            if (!((t = t.getCause()) instanceof MessageException)) continue;
            return (MessageException)t;
        }
        return new MessageException(t);
    }

    public static MessageException of(Throwable t, String message) {
        if (t == null) {
            return new MessageException(message);
        }
        if (t instanceof MessageException) {
            return (MessageException)t;
        }
        while (t.getCause() != null) {
            if (!((t = t.getCause()) instanceof MessageException)) continue;
            return (MessageException)t;
        }
        return new MessageException(t, message);
    }
}

