/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.err;

import io.polaris.core.err.MessageException;
import java.util.Collection;
import java.util.LinkedHashSet;

public class ValidationException
extends MessageException {
    private static final long serialVersionUID = 1L;
    protected Collection<ErrorDetail> errorDetails = new LinkedHashSet<ErrorDetail>();

    public ValidationException() {
    }

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(String code, String message) {
        super(code, message);
    }

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public ValidationException(Throwable cause, String message) {
        super(cause, message);
    }

    public ValidationException(Throwable cause, String code, String message) {
        super(cause, code, message);
    }

    public ValidationException(Throwable cause, boolean enableSuppression, boolean writableStackTrace, String code, String message) {
        super(cause, enableSuppression, writableStackTrace, code, message);
    }

    @Override
    public String getMessage() {
        if (this.errorDetails != null && !this.errorDetails.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            for (ErrorDetail errorDetail : this.errorDetails) {
                sb.append("\n").append(errorDetail.toString());
            }
            return sb.toString();
        }
        return super.getMessage();
    }

    public Collection<ErrorDetail> getErrorDetails() {
        return this.errorDetails;
    }

    public static class ErrorDetail {
        private String field;
        private String message;

        public String toString() {
            return "[" + this.field + "]" + this.message;
        }

        public String getField() {
            return this.field;
        }

        public String getMessage() {
            return this.message;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorDetail)) {
                return false;
            }
            ErrorDetail other = (ErrorDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field = this.field;
            String other$field = other.field;
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$message = this.message;
            String other$message = other.message;
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.field;
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $message = this.message;
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }
    }
}

