/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.guid;

import io.polaris.core.guid.GuidNodeStrategy;
import io.polaris.core.guid.Guids;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Guid {
    private static final String ZERO_PADDING_64 = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String ZERO_PADDING_16 = "0000000000000000";
    private static final String ZERO_PADDING_20 = "00000000000000000000";
    private final long unusedBits = 1L;
    private final long timestampBits;
    private final long workerIdBits;
    private final long sequenceBits;
    private final long timestampShift;
    private final long workerIdShift;
    private final long sequenceShift;
    private final long epoch = 1627747200000L;
    private final long workerId;
    private final long maxSequence;
    private final long startTimestamp;
    private final Lock lock = new ReentrantLock();
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    Guid(int workerBitSize, int workerNodeId) {
        this.timestampBits = 41L;
        this.workerIdBits = Long.max(workerBitSize, 12L);
        this.sequenceBits = 63L - this.timestampBits - this.workerIdBits;
        this.timestampShift = this.workerIdBits + this.sequenceBits;
        this.sequenceShift = this.workerIdBits;
        this.workerIdShift = 0L;
        this.workerId = workerNodeId;
        this.maxSequence = -1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.startTimestamp = System.currentTimeMillis();
    }

    public static Guid newInstance(int workerBitSize, int workerNodeId) {
        return new Guid(workerBitSize, workerNodeId);
    }

    public static Guid newInstance() {
        return Guid.newInstance(Guids.getNodeStrategy());
    }

    public static Guid newInstance(String app) {
        return Guid.newInstance(Guids.getNodeStrategy(app));
    }

    public static Guid newInstance(GuidNodeStrategy strategy) {
        if (strategy == null) {
            String app = Guids.detectStackTraceClassName();
            strategy = Guids.getNodeStrategy(app);
        }
        return new Guid(strategy.bitSize(), strategy.nodeId());
    }

    public static String bin(long d) {
        String s = Long.toBinaryString(d);
        return ZERO_PADDING_64.substring(s.length()) + s;
    }

    public static String dec(long d) {
        String s = Long.toString(d);
        return ZERO_PADDING_20.substring(s.length()) + s;
    }

    public static String hex(long d) {
        String s = Long.toHexString(d);
        return ZERO_PADDING_16.substring(s.length()) + s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        long sequence;
        long currTimestamp = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (currTimestamp <= this.lastTimestamp) {
                currTimestamp = this.lastTimestamp++;
                this.sequence = this.sequence + 1L & this.maxSequence;
                sequence = this.sequence;
                if (sequence == 0L) {
                    currTimestamp = this.lastTimestamp;
                }
            } else {
                this.sequence = 0L;
                sequence = 0L;
                this.lastTimestamp = currTimestamp;
            }
        }
        finally {
            this.lock.unlock();
        }
        return currTimestamp - 1627747200000L << (int)this.timestampShift | this.workerId << (int)this.workerIdShift | sequence << (int)this.sequenceShift;
    }

    public String nextBin() {
        return Guid.bin(this.next());
    }

    public String nextDec() {
        return Guid.dec(this.next());
    }

    public String nextHex() {
        return Guid.hex(this.next());
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public long[] parse(long id) {
        long[] arr = new long[4];
        arr[3] = ((-1L << (int)this.timestampBits ^ 0xFFFFFFFFFFFFFFFFL) << (int)this.timestampShift & id) >> (int)this.timestampShift;
        arr[0] = arr[3] + 1627747200000L;
        arr[1] = ((-1L << (int)this.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL) << (int)this.workerIdShift & id) >> (int)this.workerIdShift;
        arr[2] = ((-1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL) << (int)this.sequenceShift & id) >> (int)this.sequenceShift;
        return arr;
    }

    public String format(long id) {
        long[] arr = this.parse(id);
        String tmf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(arr[0]));
        return String.format("%s, #%d, @%d", tmf, arr[2], arr[1]);
    }
}

