/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.guid;

import io.polaris.core.guid.Guid;
import io.polaris.core.guid.GuidNodeStrategy;
import io.polaris.core.guid.GuidNodeStrategyProvider;
import io.polaris.core.guid.LocalNodeStrategy;
import io.polaris.core.service.StatefulServiceLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class Guids {
    private static final Map<String, Guid> guidCache = new ConcurrentHashMap<String, Guid>();
    private static final StatefulServiceLoader<GuidNodeStrategyProvider> guidNodeStrategyProvider = StatefulServiceLoader.load(GuidNodeStrategyProvider.class);

    public static GuidNodeStrategy getNodeStrategy() {
        return guidNodeStrategyProvider.optionalService().map(GuidNodeStrategyProvider::get).orElse(LocalNodeStrategy.getInstance(null));
    }

    public static GuidNodeStrategy getNodeStrategy(String app) {
        return guidNodeStrategyProvider.optionalService().map(p -> p.get(app)).orElse(LocalNodeStrategy.getInstance(app));
    }

    public static Guid getInstance() {
        return Guids.getInstance(Guids.detectStackTraceClassName(), null);
    }

    public static Guid getInstance(Class<?> key) {
        return Guids.getInstance(key.getName(), null);
    }

    public static Guid getInstance(String key) {
        return Guids.getInstance(key, null);
    }

    public static Guid getInstance(Class<?> key, String app) {
        return Guids.getInstance(key.getName(), app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Guid getInstance(String key, String app) {
        key = String.valueOf(key);
        app = String.valueOf(app);
        Guid guid = guidCache.get(key);
        if (guid == null) {
            Map<String, Guid> map = guidCache;
            synchronized (map) {
                guid = guidCache.get(key);
                if (guid == null) {
                    guid = Guid.newInstance(Guids.getNodeStrategy(app));
                    guidCache.put(key, guid);
                }
            }
        }
        return guid;
    }

    @Nullable
    static String detectStackTraceClassName() {
        String name = null;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < elements.length; ++i) {
            String className = elements[i].getClassName();
            if (Guids.class.getName().equals(className) || Guid.class.getName().equals(className)) continue;
            name = className;
            break;
        }
        return name;
    }
}

