/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.hash;

import io.polaris.core.lang.primitive.Bytes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class KetamaHash {
    public static long hash64(String key) {
        byte[] bKey = KetamaHash.md5(key);
        return (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
    }

    public static int hash32(String key) {
        return (int)(KetamaHash.hash64(key) & 0xFFFFFFFFL);
    }

    public static long hash(String key) {
        return KetamaHash.hash64(key);
    }

    private static byte[] md5(String key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("MD5 algorithm not support!", e);
        }
        return md5.digest(Bytes.utf8Bytes(key));
    }
}

