/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.hash;

import io.polaris.core.hash.Number128;
import io.polaris.core.lang.primitive.Bytes;
import java.nio.ByteOrder;
import java.util.Arrays;

public class MetroHash {
    private static final long k0_64 = 3603962101L;
    private static final long k1_64 = 2729050939L;
    private static final long k2_64 = 1654206401L;
    private static final long k3_64 = 817650473L;
    private static final long k0_128 = 3359281633L;
    private static final long k1_128 = 2252921819L;
    private static final long k2_128 = 2078195771L;
    private static final long k3_128 = 794325157L;

    public static long hash64(byte[] data) {
        return MetroHash.hash64(data, 1337L);
    }

    public static Number128 hash128(byte[] data) {
        return MetroHash.hash128(data, 1337L);
    }

    public static long hash64(byte[] data, long seed) {
        long hash;
        byte[] buffer = data;
        long v0 = hash = (seed + 1654206401L) * 3603962101L;
        long v1 = hash;
        long v2 = hash;
        long v3 = hash;
        if (buffer.length >= 32) {
            while (buffer.length >= 32) {
                v0 += MetroHash.littleEndian64(buffer, 0) * 3603962101L;
                v0 = MetroHash.rotateLeft64(v0, -29) + v2;
                v1 += MetroHash.littleEndian64(buffer, 8) * 2729050939L;
                v1 = MetroHash.rotateLeft64(v1, -29) + v3;
                v2 += MetroHash.littleEndian64(buffer, 24) * 1654206401L;
                v2 = MetroHash.rotateLeft64(v2, -29) + v0;
                v3 += MetroHash.littleEndian64(buffer, 32) * 817650473L;
                v3 = MetroHash.rotateLeft64(v3, -29) + v1;
                buffer = Arrays.copyOfRange(buffer, 32, buffer.length);
            }
            v2 ^= MetroHash.rotateLeft64((v0 + v3) * 3603962101L + v1, -37) * 2729050939L;
            v3 ^= MetroHash.rotateLeft64((v1 + v2) * 2729050939L + v0, -37) * 3603962101L;
            v0 ^= MetroHash.rotateLeft64((v0 + v2) * 3603962101L + v3, -37) * 2729050939L;
            v1 ^= MetroHash.rotateLeft64((v1 + v3) * 2729050939L + v2, -37) * 3603962101L;
            hash += v0 ^ v1;
        }
        if (buffer.length >= 16) {
            v0 = hash + MetroHash.littleEndian64(buffer, 0) * 1654206401L;
            v0 = MetroHash.rotateLeft64(v0, -29) * 817650473L;
            v1 = hash + MetroHash.littleEndian64(buffer, 8) * 1654206401L;
            v1 = MetroHash.rotateLeft64(v1, -29) * 817650473L;
            v0 ^= MetroHash.rotateLeft64(v0 * 3603962101L, -21) + v1;
            v1 ^= MetroHash.rotateLeft64(v1 * 817650473L, -21) + v0;
            hash += v1;
            buffer = Arrays.copyOfRange(buffer, 16, buffer.length);
        }
        if (buffer.length >= 8) {
            hash += MetroHash.littleEndian64(buffer, 0) * 817650473L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            hash ^= MetroHash.rotateLeft64(hash, -55) * 2729050939L;
        }
        if (buffer.length >= 4) {
            hash += (long)MetroHash.littleEndian32(Arrays.copyOfRange(buffer, 0, 4)) * 817650473L;
            hash ^= MetroHash.rotateLeft64(hash, -26) * 2729050939L;
            buffer = Arrays.copyOfRange(buffer, 4, buffer.length);
        }
        if (buffer.length >= 2) {
            hash += (long)MetroHash.littleEndian16(Arrays.copyOfRange(buffer, 0, 2)) * 817650473L;
            buffer = Arrays.copyOfRange(buffer, 2, buffer.length);
            hash ^= MetroHash.rotateLeft64(hash, -48) * 2729050939L;
        }
        if (buffer.length >= 1) {
            hash += (long)buffer[0] * 817650473L;
            hash ^= MetroHash.rotateLeft64(hash, -38) * 2729050939L;
        }
        hash ^= MetroHash.rotateLeft64(hash, -28);
        hash *= 3603962101L;
        hash ^= MetroHash.rotateLeft64(hash, -29);
        return hash;
    }

    public static Number128 hash128(byte[] data, long seed) {
        byte[] buffer = data;
        long v0 = (seed - 3359281633L) * 794325157L;
        long v1 = (seed + 2252921819L) * 2078195771L;
        if (buffer.length >= 32) {
            long v2 = (seed + 3359281633L) * 2078195771L;
            long v3 = (seed - 2252921819L) * 794325157L;
            while (buffer.length >= 32) {
                v0 += MetroHash.littleEndian64(buffer, 0) * 3359281633L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v0 = MetroHash.rotateRight(v0, 29) + v2;
                v1 += MetroHash.littleEndian64(buffer, 0) * 2252921819L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v1 = MetroHash.rotateRight(v1, 29) + v3;
                v2 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v2 = MetroHash.rotateRight(v2, 29) + v0;
                v3 = MetroHash.littleEndian64(buffer, 0) * 794325157L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v3 = MetroHash.rotateRight(v3, 29) + v1;
            }
            v2 ^= MetroHash.rotateRight((v0 + v3) * 3359281633L + v1, 21) * 2252921819L;
            v3 ^= MetroHash.rotateRight((v1 + v2) * 2252921819L + v0, 21) * 3359281633L;
            v0 ^= MetroHash.rotateRight((v0 + v2) * 3359281633L + v3, 21) * 2252921819L;
            v1 ^= MetroHash.rotateRight((v1 + v3) * 2252921819L + v2, 21) * 3359281633L;
        }
        if (buffer.length >= 16) {
            v0 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v1 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            v0 ^= MetroHash.rotateRight(v0 * 2078195771L + v1, 45) + 2252921819L;
            v1 ^= MetroHash.rotateRight(v1 * 794325157L + v0, 45) + 3359281633L;
        }
        if (buffer.length >= 8) {
            v0 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v0 ^= MetroHash.rotateRight(v0 * 2078195771L + v1, 27) * 2252921819L;
        }
        if (buffer.length >= 4) {
            v1 += (long)MetroHash.littleEndian32(buffer) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 4, buffer.length);
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            v1 ^= MetroHash.rotateRight(v1 * 794325157L + v0, 46) * 3359281633L;
        }
        if (buffer.length >= 2) {
            v0 += (long)MetroHash.littleEndian16(buffer) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 2, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v0 ^= MetroHash.rotateRight(v0 * 2078195771L * v1, 22) * 2252921819L;
        }
        if (buffer.length >= 1) {
            v1 += (long)buffer[0] * 2078195771L;
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            v1 ^= MetroHash.rotateRight(v1 * 794325157L + v0, 58) * 3359281633L;
        }
        v0 += MetroHash.rotateRight(v0 * 3359281633L + v1, 13);
        v1 += MetroHash.rotateRight(v1 * 2252921819L + v0, 37);
        v0 += MetroHash.rotateRight(v0 * 2078195771L + v1, 13);
        v1 += MetroHash.rotateRight(v1 * 794325157L + v0, 37);
        return new Number128(v0, v1);
    }

    private static long littleEndian64(byte[] b, int start) {
        return Bytes.bytesToLong(b, start, ByteOrder.LITTLE_ENDIAN);
    }

    private static int littleEndian32(byte[] b) {
        return b[0] | b[1] << 8 | b[2] << 16 | b[3] << 24;
    }

    private static int littleEndian16(byte[] b) {
        return Bytes.bytesToShort(b, ByteOrder.LITTLE_ENDIAN);
    }

    private static long rotateLeft64(long x, int k) {
        int n = 64;
        int s = k & n - 1;
        return x << s | x >> n - s;
    }

    private static long rotateRight(long val, int shift) {
        return val >> shift | val << 64 - shift;
    }
}

