/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.io;

import io.polaris.core.collection.Iterables;
import io.polaris.core.string.Strings;
import java.io.File;
import java.util.regex.Pattern;

public class Filenames {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_JAR = ".jar";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|\r\n]");
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (Filenames.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!Filenames.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String getSuffix(File file) {
        return Filenames.extName(file);
    }

    public static String getSuffix(String fileName) {
        return Filenames.extName(fileName);
    }

    public static String getPrefix(File file) {
        return Filenames.mainName(file);
    }

    public static String getPrefix(String fileName) {
        return Filenames.mainName(fileName);
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return Filenames.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (null == fileName) {
            return null;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        for (CharSequence specialSuffix : SPECIAL_SUFFIX) {
            if (!fileName.endsWith("." + specialSuffix)) continue;
            return fileName.substring(0, len - specialSuffix.length() - 1);
        }
        if (Filenames.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (!Filenames.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return Filenames.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, index).lastIndexOf(".");
        String substr = fileName.substring(secondToLastIndex == -1 ? index : secondToLastIndex + 1);
        if (Strings.containsAny((CharSequence)substr, SPECIAL_SUFFIX)) {
            return substr;
        }
        String ext = fileName.substring(index + 1);
        return Strings.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String cleanInvalid(String fileName) {
        return Strings.isBlank(fileName) ? fileName : FILE_NAME_INVALID_PATTERN_WIN.matcher(fileName).replaceAll("");
    }

    public static boolean containsInvalid(String fileName) {
        return false == Strings.isBlank(fileName) && FILE_NAME_INVALID_PATTERN_WIN.matcher(fileName).find();
    }

    public static boolean isType(String fileName, String ... extNames) {
        String extName = Filenames.extName(fileName);
        return Iterables.isMatchAny(extNames, x -> extName.equalsIgnoreCase((String)x));
    }
}

