/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc;

import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.ValueRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

public class TableMetaMutation {
    private final Class<?> entityClass;
    private final String newTableName;
    private final Map<String, ValueRef<String>> newColumnNames;
    private final Map<String, ColumnMeta> newColumnMetas;
    private final Map<String, ValueRef<String>> newExpressionNames;
    private final Map<String, ExpressionMeta> newExpressionMetas;
    private final boolean mutable;

    private TableMetaMutation(Class<?> entityClass, String newTableName, Map<String, ValueRef<String>> newColumnNames, Map<String, ColumnMeta> newColumnMetas, Map<String, ValueRef<String>> newExpressionNames, Map<String, ExpressionMeta> newExpressionMetas) {
        this.entityClass = entityClass;
        this.newTableName = newTableName;
        this.newColumnNames = newColumnNames;
        this.newColumnMetas = newColumnMetas;
        this.newExpressionNames = newExpressionNames;
        this.newExpressionMetas = newExpressionMetas;
        this.mutable = Strings.isNotBlank(newTableName) || newColumnNames != null && !newColumnNames.isEmpty() || newColumnMetas != null && !newColumnMetas.isEmpty() || newExpressionNames != null && !newExpressionNames.isEmpty() || newExpressionMetas != null && !newExpressionMetas.isEmpty();
    }

    public static TableMetaMutation origin(Class<?> entityClass) {
        return new TableMetaMutation(entityClass, null, null, null, null, null);
    }

    public static Builder builder(Class<?> entityClass) {
        return new Builder(entityClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMetaMutation)) {
            return false;
        }
        TableMetaMutation that = (TableMetaMutation)o;
        return this.mutable == that.mutable && Objects.equals(this.entityClass, that.entityClass) && Objects.equals(this.newTableName, that.newTableName) && Objects.equals(this.newColumnNames, that.newColumnNames) && Objects.equals(this.newColumnMetas, that.newColumnMetas) && Objects.equals(this.newExpressionNames, that.newExpressionNames) && Objects.equals(this.newExpressionMetas, that.newExpressionMetas);
    }

    public int hashCode() {
        return Objects.hash(this.entityClass, this.newTableName, this.newColumnNames, this.newColumnMetas, this.newExpressionNames, this.newExpressionMetas, this.mutable);
    }

    public TableMeta apply(TableMeta origin) {
        if (!this.mutable) {
            return origin;
        }
        String tableName = Strings.isBlank(this.newTableName) ? origin.getTable() : this.newTableName;
        Map<String, ColumnMeta> columns = origin.getColumns();
        Map<String, ExpressionMeta> expressions = origin.getExpressions();
        if (this.newColumnMetas != null && !this.newColumnMetas.isEmpty() || this.newColumnNames != null && !this.newColumnNames.isEmpty()) {
            HashMap<String, ColumnMeta> newColumns = new HashMap<String, ColumnMeta>(columns);
            if (this.newColumnNames != null && !this.newColumnNames.isEmpty()) {
                columns.forEach((key, value) -> {
                    ValueRef<String> ref = this.newColumnNames.get(key);
                    if (ref != null && Strings.isBlank(ref.get())) {
                        newColumns.remove(key);
                        return;
                    }
                    String columnName = ref == null ? value.getColumnName() : ref.get();
                    ColumnMeta columnMeta = ColumnMeta.builder().tableName(tableName).schema(value.getSchema()).catalog(value.getCatalog()).fieldName(value.getFieldName()).fieldType(value.getFieldType()).columnName(columnName).jdbcType(value.getJdbcType()).jdbcTypeValue(value.getJdbcTypeValue()).updateDefault(value.getUpdateDefault()).insertDefault(value.getInsertDefault()).nullable(value.isNullable()).insertable(value.isInsertable()).updatable(value.isUpdatable()).version(value.isVersion()).logicDeleted(value.isLogicDeleted()).createTime(value.isCreateTime()).updateTime(value.isUpdateTime()).primaryKey(value.isPrimaryKey()).autoIncrement(value.isAutoIncrement()).seqName(value.getSeqName()).build();
                    newColumns.put((String)key, columnMeta);
                });
            }
            if (this.newColumnMetas != null && !this.newColumnMetas.isEmpty()) {
                newColumns.putAll(this.newColumnMetas);
            }
            columns = Collections.unmodifiableMap(newColumns);
        }
        if (this.newExpressionMetas != null && !this.newExpressionMetas.isEmpty() || this.newExpressionNames != null && !this.newExpressionNames.isEmpty()) {
            HashMap<String, ExpressionMeta> newExpressions = new HashMap<String, ExpressionMeta>(expressions);
            if (this.newExpressionNames != null && !this.newExpressionNames.isEmpty()) {
                expressions.forEach((key, value) -> {
                    ValueRef<String> ref = this.newExpressionNames.get(key);
                    if (ref != null && Strings.isBlank(ref.get())) {
                        newExpressions.remove(key);
                        return;
                    }
                    String expression = ref == null ? value.getExpression() : ref.get();
                    ExpressionMeta columnMeta = ExpressionMeta.builder().tableName(tableName).schema(value.getSchema()).catalog(value.getCatalog()).fieldName(value.getFieldName()).fieldType(value.getFieldType()).expression(expression).jdbcType(value.getJdbcType()).jdbcTypeValue(value.getJdbcTypeValue()).tableAliasPlaceholder(value.getTableAliasPlaceholder()).selectable(value.isSelectable()).build();
                    newExpressions.put((String)key, columnMeta);
                });
            }
            if (this.newExpressionMetas != null && !this.newExpressionMetas.isEmpty()) {
                newExpressions.putAll(this.newExpressionMetas);
            }
            expressions = Collections.unmodifiableMap(newExpressions);
        }
        return TableMeta.builder().entityClass(origin.getEntityClass()).table(tableName).alias(origin.getAlias()).columns(columns).expressions(expressions).schema(origin.getSchema()).catalog(origin.getCatalog()).build();
    }

    public boolean mutable() {
        return this.mutable;
    }

    public Class<?> entityClass() {
        return this.entityClass;
    }

    @NotThreadSafe
    public static final class Builder {
        private final Class<?> entityClass;
        private String newTableName;
        private Map<String, ValueRef<String>> newColumnNames;
        private Map<String, ColumnMeta> newColumnMetas;
        private Map<String, ValueRef<String>> newExpressionNames;
        private Map<String, ExpressionMeta> newExpressionMetas;

        public Builder(Class<?> entityClass) {
            this.entityClass = entityClass;
        }

        public Builder renameTable(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public Builder renameColumn(String fieldName, String columnName) {
            if (this.newColumnNames == null) {
                this.newColumnNames = new HashMap<String, ValueRef<String>>();
            }
            this.newColumnNames.put(fieldName, ValueRef.of(columnName));
            return this;
        }

        public Builder deleteColumn(String fieldName) {
            return this.renameColumn(fieldName, null);
        }

        public Builder addColumn(ColumnMeta columnMeta) {
            if (this.newColumnMetas == null) {
                this.newColumnMetas = new HashMap<String, ColumnMeta>();
            }
            this.newColumnMetas.put(columnMeta.getFieldName(), columnMeta);
            return this;
        }

        public Builder renameExpression(String fieldName, String expression) {
            if (this.newExpressionNames == null) {
                this.newExpressionNames = new HashMap<String, ValueRef<String>>();
            }
            this.newExpressionNames.put(fieldName, ValueRef.of(expression));
            return this;
        }

        public Builder deleteExpression(String fieldName) {
            return this.renameExpression(fieldName, null);
        }

        public Builder addExpression(ExpressionMeta expressionMeta) {
            if (this.newExpressionMetas == null) {
                this.newExpressionMetas = new HashMap<String, ExpressionMeta>();
            }
            this.newExpressionMetas.put(expressionMeta.getFieldName(), expressionMeta);
            return this;
        }

        public TableMetaMutation build() {
            return new TableMetaMutation(this.entityClass, this.newTableName, this.newColumnNames == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.newColumnNames), this.newColumnMetas == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.newColumnMetas), this.newExpressionNames == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.newExpressionNames), this.newExpressionMetas == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.newExpressionMetas));
        }
    }
}

