/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BaseResultRowMapper;
import io.polaris.core.map.Maps;
import io.polaris.core.reflect.Reflects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Supplier;

public class ResultRowMapMapper<T extends Map<String, Object>>
extends BaseResultRowMapper<T> {
    private final Supplier<T> mapBuilder;

    public ResultRowMapMapper() {
        this(() -> Maps.newUpperCaseLinkedHashMap());
    }

    public ResultRowMapMapper(Class<T> type) {
        this(() -> (Map)Reflects.newInstanceIfPossible(type));
    }

    public ResultRowMapMapper(Supplier<T> mapBuilder) {
        this.mapBuilder = mapBuilder;
    }

    @Override
    protected T doMap(ResultSet rs, String[] columns) throws SQLException {
        Map map = (Map)this.mapBuilder.get();
        for (int i = 1; i <= columns.length; ++i) {
            String key = columns[i - 1];
            map.put(key, rs.getObject(i));
        }
        return (T)map;
    }
}

