/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.executor;

import io.polaris.core.jdbc.executor.InvocationHandlerHolder;
import io.polaris.core.jdbc.executor.JdbcBatchExecutor;
import io.polaris.core.jdbc.executor.JdbcExecutor;
import io.polaris.core.jdbc.executor.StatefulJdbcExecutor;
import io.polaris.core.map.Maps;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class JdbcExecutors {
    private static final ThreadLocal<Connection> currentConnection = new ThreadLocal();
    private static final Map<Class<?>, Object> executorCache = Maps.newSoftMap(new ConcurrentHashMap());

    public static <T> T createExecutor(Class<T> interfaceClass) {
        return (T)executorCache.computeIfAbsent(interfaceClass, JdbcExecutors::doCreateExecutor);
    }

    private static <T> T doCreateExecutor(Class<T> interfaceClass) {
        JdbcExecutor<T> handler = new JdbcExecutor<T>(interfaceClass);
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass, InvocationHandlerHolder.class}, handler);
    }

    public static <T> T createExecutor(Class<T> interfaceClass, Connection connection, boolean batch) {
        StatefulJdbcExecutor<T> handler = new StatefulJdbcExecutor<T>(interfaceClass, connection, batch);
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass, InvocationHandlerHolder.class, JdbcBatchExecutor.class}, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void doBatch(Class<T> interfaceClass, Connection connection, Consumer<T> consumer) {
        Object executor = null;
        try {
            executor = JdbcExecutors.createExecutor(interfaceClass, connection, true);
            consumer.accept(executor);
        }
        finally {
            if (executor instanceof JdbcBatchExecutor) {
                try {
                    ((JdbcBatchExecutor)executor).flush();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void doWithConnection(Class<T> interfaceClass, Connection connection, Consumer<T> consumer) {
        JdbcExecutors.setCurrentConnection(connection);
        try {
            T executor = JdbcExecutors.createExecutor(interfaceClass);
            consumer.accept(executor);
        }
        finally {
            JdbcExecutors.clearCurrentConnection();
        }
    }

    public static <T> T doWithConnection(Connection connection, Supplier<T> executor) {
        JdbcExecutors.setCurrentConnection(connection);
        try {
            T t = executor.get();
            return t;
        }
        finally {
            JdbcExecutors.clearCurrentConnection();
        }
    }

    public static void doWithConnection(Connection connection, Runnable executor) {
        JdbcExecutors.setCurrentConnection(connection);
        try {
            executor.run();
        }
        finally {
            JdbcExecutors.clearCurrentConnection();
        }
    }

    public static Connection getCurrentConnection() {
        return currentConnection.get();
    }

    public static void setCurrentConnection(Connection connection) {
        currentConnection.set(connection);
    }

    public static void clearCurrentConnection() {
        currentConnection.remove();
    }
}

