/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.VarNameGenerator;
import java.util.Collections;

@AnnotationProcessing
public class TextNode
implements SqlNode,
Cloneable {
    private String text;

    public TextNode(String text) {
        this.text = text;
    }

    public String toString() {
        return this.asPreparedSql().getText();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public PreparedSql asPreparedSql() {
        if (this.text == null || this.text.isEmpty()) {
            return PreparedSql.EMPTY;
        }
        return new PreparedSql(this.text, Collections.emptyList());
    }

    @Override
    public BoundSql asBoundSql(VarNameGenerator generator, String openVarToken, String closeVarToken) {
        if (this.text == null || this.text.isEmpty()) {
            return BoundSql.EMPTY;
        }
        return new BoundSql(this.text, Collections.emptyMap());
    }

    @Override
    public TextNode copy() {
        return this.copy(true);
    }

    @Override
    public TextNode copy(boolean withVarValue) {
        return new TextNode(this.text);
    }

    public TextNode clone() {
        return this.copy(true);
    }

    @Override
    public boolean isTextNode() {
        return true;
    }
}

