/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.jdbc.sql.node.SqlNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public abstract class VarNode
implements SqlNode {
    protected final String varName;
    protected Object varValue;
    protected List<Object> varValues;

    public VarNode(String varName) {
        this.varName = varName;
    }

    public String toString() {
        return this.asPreparedSql().getText();
    }

    @Override
    public boolean isVarNode() {
        return true;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public void removeVarValue() {
        this.varValue = null;
        this.varValues = null;
    }

    @Override
    public Object getVarValue() {
        return this.varValue;
    }

    protected List<Object> getVarValues() {
        return this.varValues;
    }

    @Override
    public void bindVarValue(Object param) {
        this.varValue = param;
        this.varValues = new ArrayList<Object>();
        this.addVarValuesToList(param, this.varValues);
    }

    private void addVarValuesToList(Object varValue, List<Object> list) {
        if (varValue == null) {
            list.add(null);
            return;
        }
        if (varValue instanceof List && varValue instanceof RandomAccess) {
            int size = ((List)varValue).size();
            for (int i = 0; i < size; ++i) {
                Object o = ((List)varValue).get(i);
                this.addVarValuesToList(o, list);
            }
            return;
        }
        if (varValue instanceof Iterable) {
            for (Object o : (Iterable)varValue) {
                this.addVarValuesToList(o, list);
            }
            return;
        }
        if (varValue instanceof Iterator) {
            ((Iterator)varValue).forEachRemaining(parameter1 -> this.addVarValuesToList(parameter1, list));
            return;
        }
        if (varValue instanceof Map) {
            Collection values = ((Map)varValue).values();
            values.forEach(parameter1 -> this.addVarValuesToList(parameter1, list));
            return;
        }
        if (varValue.getClass().isArray()) {
            int len = Array.getLength(varValue);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    this.addVarValuesToList(Array.get(varValue, i), list);
                }
            }
            return;
        }
        list.add(varValue);
    }
}

