/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.query;

import io.polaris.core.collection.Iterables;
import io.polaris.core.jdbc.sql.consts.Relation;
import io.polaris.core.jdbc.sql.query.Criterion;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;

public class Criteria {
    private Relation relation;
    private List<Criteria> subset = null;
    private String field;
    private Criterion criterion;

    public static Criteria newCriteria() {
        return new Criteria();
    }

    public boolean isValid() {
        if (!Iterables.isEmpty(this.subset)) {
            return true;
        }
        return Strings.isNotBlank(this.field) && this.criterion != null && this.criterion.isValid();
    }

    public Criteria field(String field) {
        this.field = field;
        return this;
    }

    public Criteria criterion(Criterion criterion) {
        this.criterion = criterion;
        return this;
    }

    public Criteria relation(Relation relation) {
        this.relation = relation;
        return this;
    }

    public Criteria addSubset(List<Criteria> list) {
        (this.subset == null ? (this.subset = new ArrayList<Criteria>()) : this.subset).addAll(list);
        return this;
    }

    public Criteria addSubset(Criteria condition) {
        (this.subset == null ? (this.subset = new ArrayList<Criteria>()) : this.subset).add(condition);
        return this;
    }

    public Criteria clearSubset() {
        if (this.subset != null) {
            this.subset.clear();
        }
        return this;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public List<Criteria> getSubset() {
        return this.subset;
    }

    public String getField() {
        return this.field;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setSubset(List<Criteria> subset) {
        this.subset = subset;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setCriterion(Criterion criterion) {
        this.criterion = criterion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Criteria)) {
            return false;
        }
        Criteria other = (Criteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Relation this$relation = this.relation;
        Relation other$relation = other.relation;
        if (this$relation == null ? other$relation != null : !((Object)((Object)this$relation)).equals((Object)other$relation)) {
            return false;
        }
        List<Criteria> this$subset = this.subset;
        List<Criteria> other$subset = other.subset;
        if (this$subset == null ? other$subset != null : !((Object)this$subset).equals(other$subset)) {
            return false;
        }
        String this$field = this.field;
        String other$field = other.field;
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Criterion this$criterion = this.criterion;
        Criterion other$criterion = other.criterion;
        return !(this$criterion == null ? other$criterion != null : !((Object)this$criterion).equals(other$criterion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Criteria;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Relation $relation = this.relation;
        result = result * 59 + ($relation == null ? 43 : ((Object)((Object)$relation)).hashCode());
        List<Criteria> $subset = this.subset;
        result = result * 59 + ($subset == null ? 43 : ((Object)$subset).hashCode());
        String $field = this.field;
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Criterion $criterion = this.criterion;
        result = result * 59 + ($criterion == null ? 43 : ((Object)$criterion).hashCode());
        return result;
    }
}

