/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.query;

import io.polaris.core.collection.Iterables;
import io.polaris.core.jdbc.sql.consts.Operator;
import io.polaris.core.jdbc.sql.consts.Relation;
import java.util.ArrayList;
import java.util.List;

public class Criterion {
    private Relation relation;
    private List<Criterion> subset = null;
    private Operator operator = Operator.EQ;
    private Object value;
    private String reference;

    public static Criterion newCriterion() {
        return new Criterion();
    }

    public boolean isValid() {
        if (!Iterables.isEmpty(this.subset)) {
            return true;
        }
        return this.operator != null;
    }

    public Criterion operator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public Criterion value(Object value) {
        this.value = value;
        return this;
    }

    public Criterion reference(String reference) {
        this.reference = reference;
        return this;
    }

    public Criterion relation(Relation relation) {
        this.relation = relation;
        return this;
    }

    public Criterion addSubset(List<Criterion> list) {
        (this.subset == null ? (this.subset = new ArrayList<Criterion>()) : this.subset).addAll(list);
        return this;
    }

    public Criterion addSubset(Criterion criterion) {
        (this.subset == null ? (this.subset = new ArrayList<Criterion>()) : this.subset).add(criterion);
        return this;
    }

    public Criterion clearSubset() {
        if (this.subset != null) {
            this.subset.clear();
        }
        return this;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public List<Criterion> getSubset() {
        return this.subset;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public String getReference() {
        return this.reference;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setSubset(List<Criterion> subset) {
        this.subset = subset;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Criterion)) {
            return false;
        }
        Criterion other = (Criterion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Relation this$relation = this.relation;
        Relation other$relation = other.relation;
        if (this$relation == null ? other$relation != null : !((Object)((Object)this$relation)).equals((Object)other$relation)) {
            return false;
        }
        List<Criterion> this$subset = this.subset;
        List<Criterion> other$subset = other.subset;
        if (this$subset == null ? other$subset != null : !((Object)this$subset).equals(other$subset)) {
            return false;
        }
        Operator this$operator = this.operator;
        Operator other$operator = other.operator;
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Object this$value = this.value;
        Object other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$reference = this.reference;
        String other$reference = other.reference;
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Criterion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Relation $relation = this.relation;
        result = result * 59 + ($relation == null ? 43 : ((Object)((Object)$relation)).hashCode());
        List<Criterion> $subset = this.subset;
        result = result * 59 + ($subset == null ? 43 : ((Object)$subset).hashCode());
        Operator $operator = this.operator;
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        Object $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $reference = this.reference;
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }
}

