/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.query;

import io.polaris.core.collection.Iterables;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.jdbc.sql.consts.Direction;
import io.polaris.core.jdbc.sql.consts.Operator;
import io.polaris.core.jdbc.sql.consts.Relation;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.Criterion;
import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.string.Strings;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Queries {
    public static Function<String, String> newColumnDiscovery(Class<?> entityClass) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        return Queries.newColumnDiscovery(tableMeta);
    }

    public static Function<String, String> newColumnDiscovery(TableMeta tableMeta) {
        return field -> {
            String[] arr = field.split(Pattern.quote("."), 2);
            String alias = null;
            if (arr.length == 2) {
                alias = arr[0].trim();
                field = arr[1].trim();
            }
            if (alias != null) {
                if (Strings.equalsIgnoreCase(alias, tableMeta.getAlias())) {
                    ColumnMeta columnMeta = tableMeta.getColumns().get(field);
                    if (columnMeta != null) {
                        return alias + "." + columnMeta.getColumnName();
                    }
                    ExpressionMeta expressionMeta = tableMeta.getExpressions().get(field);
                    if (expressionMeta != null) {
                        if (Strings.isNotBlank(expressionMeta.getTableAliasPlaceholder())) {
                            return expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), alias + ".");
                        }
                        return expressionMeta.getExpression();
                    }
                }
            } else {
                ColumnMeta columnMeta = tableMeta.getColumns().get(field);
                if (columnMeta != null) {
                    return columnMeta.getColumnName();
                }
                ExpressionMeta expressionMeta = tableMeta.getExpressions().get(field);
                if (expressionMeta != null) {
                    if (Strings.isNotBlank(expressionMeta.getTableAliasPlaceholder())) {
                        return expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), "");
                    }
                    return expressionMeta.getExpression();
                }
            }
            return null;
        };
    }

    public static Function<String, String> newColumnDiscovery(Class<?> entityClass, String alias) {
        return Queries.newColumnDiscovery(TableSegment.fromEntity(entityClass, alias));
    }

    public static Function<String, String> newColumnDiscovery(Class<?> entityClass1, String alias1, Class<?> entityClass2, String alias2) {
        return Queries.newColumnDiscovery(TableSegment.fromEntity(entityClass1, alias1), TableSegment.fromEntity(entityClass2, alias2));
    }

    public static Function<String, String> newColumnDiscovery(Class<?> entityClass1, String alias1, Class<?> entityClass2, String alias2, Class<?> entityClass3, String alias3) {
        return Queries.newColumnDiscovery(TableSegment.fromEntity(entityClass1, alias1), TableSegment.fromEntity(entityClass2, alias2), TableSegment.fromEntity(entityClass3, alias3));
    }

    public static Function<String, String> newColumnDiscovery(TableSegment<?> ... tables) {
        return field -> {
            String[] arr = field.split(Pattern.quote("."), 2);
            String alias = null;
            if (arr.length == 2) {
                alias = arr[0].trim();
                field = arr[1].trim();
            }
            try {
                if (tables != null) {
                    for (TableSegment table : tables) {
                        String col;
                        if (alias != null && !Strings.equalsIgnoreCase(alias, table.getTableAlias()) || !Strings.isNotBlank(col = table.getColumnExpression((String)field))) continue;
                        return col;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
    }

    public static Criteria newCriteria(Object entity) {
        return Queries.newCriteria(entity, null);
    }

    public static Criteria newCriteria(Object entity, Class<?> entityClass) {
        Object val;
        Cloneable meta;
        String name;
        Criteria criteria = Criteria.newCriteria();
        if (entityClass == null) {
            entityClass = entity.getClass();
        }
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : Beans.newBeanMap(entity, entityClass);
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            name = entry.getKey();
            meta = entry.getValue();
            val = entityMap.get(name);
            if (!Objs.isNotEmpty(val)) continue;
            if (val instanceof Iterable || val instanceof Iterator) {
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.IN).value(val)));
                continue;
            }
            if (val.getClass().isArray()) {
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.IN).value(val)));
                continue;
            }
            if (String.class == ((ColumnMeta)meta).getFieldType() && val instanceof String) {
                if (((String)val).startsWith("%") || ((String)val).endsWith("%")) {
                    criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.LIKE).value(val)));
                    continue;
                }
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.EQ).value(val)));
                continue;
            }
            criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.EQ).value(val)));
        }
        for (Map.Entry<String, Cloneable> entry : tableMeta.getExpressions().entrySet()) {
            name = entry.getKey();
            meta = (ExpressionMeta)entry.getValue();
            val = entityMap.get(name);
            if (!Objs.isNotEmpty(val)) continue;
            if (val instanceof Iterable || val instanceof Iterator) {
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.IN).value(val)));
                continue;
            }
            if (val.getClass().isArray()) {
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.IN).value(val)));
                continue;
            }
            if (String.class == ((ExpressionMeta)meta).getFieldType() && val instanceof String) {
                if (((String)val).startsWith("%") || ((String)val).endsWith("%")) {
                    criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.LIKE).value(val)));
                    continue;
                }
                criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.EQ).value(val)));
                continue;
            }
            criteria.addSubset(Criteria.newCriteria().field(name).criterion(Criterion.newCriterion().operator(Operator.EQ).value(val)));
        }
        return criteria;
    }

    public static OrderBy newOrderBy(String orderBySql) {
        OrderBy orderBy = OrderBy.newOrderBy();
        if (Strings.isNotBlank(orderBySql)) {
            String[] items;
            for (String item : items = orderBySql.split(",")) {
                String[] arr = item.trim().split("\\s+", 2);
                if (arr.length == 2) {
                    orderBy.by(Direction.parse(arr[1]), arr[0]);
                    continue;
                }
                orderBy.by(arr[0]);
            }
        }
        return orderBy;
    }

    public static SqlNode parse(OrderBy orderBy, Function<String, String> columnDiscovery) {
        ContainerNode sql = new ContainerNode();
        boolean first = true;
        for (OrderBy.Item item : orderBy.getItems()) {
            String column = columnDiscovery.apply(item.getField());
            if (!Strings.isNotBlank(column)) continue;
            if (first) {
                first = false;
            } else {
                sql.addNode(SqlNodes.COMMA);
            }
            sql.addNode(new TextNode(column));
            sql.addNode(SqlNodes.BLANK);
            sql.addNode(item.getDirection().getTextNode());
        }
        return sql;
    }

    public static SqlNode parse(Criteria criteria) {
        return Queries.parse(criteria, false, Function.identity());
    }

    public static SqlNode parse(Criteria criteria, boolean supportReplacement) {
        return Queries.parse(criteria, supportReplacement, Function.identity());
    }

    public static SqlNode parse(Criteria criteria, Function<String, String> columnDiscovery) {
        return Queries.parse(criteria, false, columnDiscovery);
    }

    public static SqlNode parse(Criteria criteria, boolean supportReplacement, Function<String, String> columnDiscovery) {
        ContainerNode sql = new ContainerNode();
        if (!Iterables.isEmpty(criteria.getSubset())) {
            boolean first = true;
            for (Criteria subset : criteria.getSubset()) {
                SqlNode sqlNode = Queries.parse(subset, supportReplacement, columnDiscovery);
                if (sqlNode.isSkipped()) continue;
                if (first) {
                    first = false;
                } else {
                    sql.addNode(Queries.getRelationOrDefault(criteria).getTextNode());
                }
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                sql.addNodes(sqlNode.subset());
                sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            }
        } else if (Strings.isNotBlank(criteria.getField()) && criteria.getCriterion() != null) {
            SqlNode sqlNode;
            Criterion criterion = criteria.getCriterion();
            String column = columnDiscovery.apply(criteria.getField());
            if (Strings.isNotBlank(column) && !(sqlNode = Queries.parse(column, criterion, supportReplacement)).isSkipped()) {
                sql.addNodes(sqlNode.subset());
            }
        }
        return sql;
    }

    public static SqlNode parse(String column, Criterion criterion, boolean supportReplacement) {
        ContainerNode sql = new ContainerNode();
        if (!Iterables.isEmpty(criterion.getSubset())) {
            boolean first = true;
            for (Criterion sub : criterion.getSubset()) {
                SqlNode sqlNode = Queries.parse(column, sub, supportReplacement);
                if (sqlNode.isSkipped()) continue;
                if (first) {
                    first = false;
                } else {
                    sql.addNode(Queries.getRelationOrDefault(criterion).getTextNode());
                }
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                sql.addNodes(sqlNode.subset());
                sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            }
        } else if (criterion.getOperator() != null) {
            Operator symbol = criterion.getOperator();
            ContainerNode sqlNode = symbol.toSqlNode(column, "", criterion.getValue(), supportReplacement ? criterion.getReference() : null);
            sqlNode.skipIfMissingVarValue();
            if (!sqlNode.isSkipped()) {
                sql.addNodes(sqlNode.subset());
            }
        }
        return sql;
    }

    private static Relation getRelationOrDefault(Criteria criteria) {
        Relation relation = criteria.getRelation();
        if (relation == null) {
            relation = Relation.AND;
        }
        return relation;
    }

    private static Relation getRelationOrDefault(Criterion condition) {
        Relation relation = condition.getRelation();
        if (relation == null) {
            relation = Relation.AND;
        }
        return relation;
    }
}

