/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.Queries;
import io.polaris.core.jdbc.sql.statement.BaseStatement;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@AnnotationProcessing
public class DeleteStatement<S extends DeleteStatement<S>>
extends BaseStatement<S>
implements TableAccessible {
    private final TableSegment<?> table;
    private AndSegment<S, ?> where;
    private final Function<String, String> columnDiscovery;
    private final List<Criteria> criteriaList = new ArrayList<Criteria>();

    @AnnotationProcessing
    public DeleteStatement(Class<?> entityClass) {
        this(entityClass, null);
    }

    @AnnotationProcessing
    public DeleteStatement(Class<?> entityClass, String alias) {
        this.table = TableSegment.fromEntity(entityClass, alias);
        this.columnDiscovery = this.columnDiscovery();
    }

    public static DeleteStatement<?> of(Class<?> entityClass, String alias) {
        return new DeleteStatement(entityClass, alias);
    }

    private Function<String, String> columnDiscovery() {
        return field -> {
            String col = null;
            try {
                if (this.table != null) {
                    col = this.table.getColumnExpression((String)field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return col;
        };
    }

    @AnnotationProcessing
    protected AndSegment<S, ?> buildWhere() {
        return new AndSegment(this.getThis(), this.table);
    }

    @Override
    public SqlNode toSqlNode() {
        ContainerNode sql = new ContainerNode();
        this.sqlDelete(sql);
        this.sqlWhere(sql);
        return sql;
    }

    private void sqlDelete(ContainerNode sql) {
        if (this.table != null) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            sql.addNode(SqlNodes.DELETE);
            sql.addNode(SqlNodes.FROM);
            sql.addNode(this.table.toSqlNode());
        }
    }

    private void sqlWhere(ContainerNode sql) {
        SqlNode sqlNode;
        boolean first = true;
        if (this.where != null && !(sqlNode = this.where.toSqlNode()).isSkipped()) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            first = false;
            sql.addNode(SqlNodes.WHERE);
            sql.addNode(sqlNode);
        }
        if (!this.criteriaList.isEmpty()) {
            for (Criteria criteria : this.criteriaList) {
                SqlNode sqlNode2 = Queries.parse(criteria, false, this.columnDiscovery);
                if (sqlNode2.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.WHERE);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.AND);
                }
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                sql.addNode(sqlNode2);
                sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            }
        }
    }

    public S where(Criteria criteria) {
        if (criteria != null) {
            this.criteriaList.add(criteria);
        }
        return (S)((DeleteStatement)this.getThis());
    }

    @AnnotationProcessing
    public <W extends AndSegment<S, W>> W where() {
        this.where = Objs.defaultIfNull(this.where, this::buildWhere);
        return (W)this.where;
    }

    @AnnotationProcessing
    public TableSegment<?> getTable() {
        return this.table;
    }

    @Override
    public TableSegment<?> getTable(int tableIndex) {
        if (tableIndex < 0) {
            throw new IllegalArgumentException("tableIndex: " + tableIndex);
        }
        if (tableIndex == 0) {
            return this.table;
        }
        throw new IllegalArgumentException("no such table! tableIndex: " + tableIndex);
    }

    @Override
    public TableSegment<?> getTable(String tableAlias) {
        if (Objs.equals(this.table.getTableAlias(), tableAlias)) {
            return this.table;
        }
        throw new IllegalArgumentException("no such table! tableAlias: " + tableAlias);
    }
}

