/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.expression.Expression;
import io.polaris.core.jdbc.sql.statement.segment.SqlSourceSupplier;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import java.util.Map;

public class ExpressionSegment<S extends ExpressionSegment<S>>
extends BaseSegment<S> {
    private final Expression expression;
    private final SqlSourceSupplier extSourcesSupplier;
    private final Object[] bindingArray;
    private final Map<String, Object> bindingMap;
    private final ExpressionSegment<?> nested;

    public ExpressionSegment(Expression expression, Object ... bindings) {
        this((ExpressionSegment<?>)null, SqlSourceSupplier.EMPTY, expression, bindings);
    }

    public ExpressionSegment(Expression expression, Map<String, Object> bindings) {
        this(null, SqlSourceSupplier.EMPTY, expression, bindings);
    }

    public ExpressionSegment(SqlSourceSupplier extSourcesSupplier, Expression expression, Object ... bindings) {
        this((ExpressionSegment<?>)null, extSourcesSupplier, expression, bindings);
    }

    public ExpressionSegment(SqlSourceSupplier extSourcesSupplier, Expression expression, Map<String, Object> bindings) {
        this(null, extSourcesSupplier, expression, bindings);
    }

    public ExpressionSegment(ExpressionSegment<?> nested, Expression expression, Object ... bindings) {
        this(nested, SqlSourceSupplier.EMPTY, expression, bindings);
    }

    public ExpressionSegment(ExpressionSegment<?> nested, Expression expression, Map<String, Object> bindings) {
        this(nested, SqlSourceSupplier.EMPTY, expression, bindings);
    }

    public ExpressionSegment(ExpressionSegment<?> nested, SqlSourceSupplier extSourcesSupplier, Expression expression, Object ... bindings) {
        this(nested, extSourcesSupplier, expression, (Object)bindings);
    }

    public ExpressionSegment(ExpressionSegment<?> nested, SqlSourceSupplier extSourcesSupplier, Expression expression, Map<String, Object> bindings) {
        this(nested, extSourcesSupplier, expression, (Object)bindings);
    }

    private ExpressionSegment(ExpressionSegment<?> nested, SqlSourceSupplier extSourcesSupplier, Expression expression, Object bindings) {
        this.nested = nested;
        this.extSourcesSupplier = extSourcesSupplier == null ? SqlSourceSupplier.EMPTY : extSourcesSupplier;
        this.expression = expression;
        if (bindings instanceof Map) {
            this.bindingMap = (Map)bindings;
            this.bindingArray = null;
        } else {
            this.bindingArray = (Object[])bindings;
            this.bindingMap = null;
        }
    }

    public ExpressionSegment(ExpressionSegment<?> nested, TableAccessible tableAccessible, TableField[] extFields, Expression expression, Object ... bindings) {
        this(nested, tableAccessible, extFields, expression, (Object)bindings);
    }

    public ExpressionSegment(ExpressionSegment<?> nested, TableAccessible tableAccessible, TableField[] extFields, Expression expression, Map<String, Object> bindings) {
        this(nested, tableAccessible, extFields, expression, (Object)bindings);
    }

    private ExpressionSegment(ExpressionSegment<?> nested, TableAccessible tableAccessible, TableField[] extFields, Expression expression, Object bindings) {
        this.nested = nested;
        this.extSourcesSupplier = extFields == null || extFields.length == 0 ? SqlSourceSupplier.EMPTY : () -> {
            SqlNode[] sqlNodes = new SqlNode[extFields.length];
            for (int i = 0; i < extFields.length; ++i) {
                String columnExpression;
                TableSegment<?> table;
                TableField tableField = extFields[i];
                Integer tableIndex = tableField.getTableIndex();
                if (tableIndex != null) {
                    table = tableAccessible.getTable(tableIndex);
                    columnExpression = table.getColumnExpression(tableField.getFieldName());
                    sqlNodes[i] = new TextNode(columnExpression);
                    continue;
                }
                table = tableAccessible.getTable(tableField.getTableAlias());
                columnExpression = table.getColumnExpression(tableField.getFieldName());
                sqlNodes[i] = new TextNode(columnExpression);
            }
            return sqlNodes;
        };
        this.expression = expression;
        if (bindings instanceof Map) {
            this.bindingMap = (Map)bindings;
            this.bindingArray = null;
        } else {
            this.bindingArray = (Object[])bindings;
            this.bindingMap = null;
        }
    }

    public SqlNode toSqlNode(String source) {
        return this.toSqlNode(new TextNode(source));
    }

    public SqlNode toSqlNode(SqlNode source) {
        if (this.nested != null) {
            SqlNode sqlNode = this.nested.toSqlNode(source);
            if (this.bindingMap != null) {
                return this.expression.toSqlNode(sqlNode, (SqlNode[])this.extSourcesSupplier.get(), this.bindingMap);
            }
            return this.expression.toSqlNode(sqlNode, (SqlNode[])this.extSourcesSupplier.get(), this.bindingArray);
        }
        if (this.bindingMap != null) {
            return this.expression.toSqlNode(source, (SqlNode[])this.extSourcesSupplier.get(), this.bindingMap);
        }
        return this.expression.toSqlNode(source, (SqlNode[])this.extSourcesSupplier.get(), this.bindingArray);
    }
}

