/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.consts.StdConsts;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.expression.AggregateFunction;
import io.polaris.core.jdbc.sql.statement.expression.Expression;
import io.polaris.core.jdbc.sql.statement.expression.Expressions;
import io.polaris.core.jdbc.sql.statement.segment.ExpressionSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.util.Map;

@AnnotationProcessing
public class OrderBySegment<O extends Segment<O>, S extends OrderBySegment<O, S>>
extends BaseSegment<S>
implements SqlNodeBuilder {
    private final O owner;
    private final TableSegment<?> table;
    private final TableAccessible tableAccessible;
    private boolean asc = true;
    private String field;
    private transient String _rawColumn;
    private SqlNode sql;
    private ExpressionSegment<?> expression;

    @AnnotationProcessing
    public OrderBySegment(O owner, TableSegment<?> table) {
        this.owner = owner;
        this.table = table;
        this.tableAccessible = this.fetchTableAccessible();
    }

    private TableAccessible fetchTableAccessible() {
        if (this.owner instanceof TableAccessible) {
            return (TableAccessible)this.owner;
        }
        if (this.owner instanceof TableAccessibleHolder) {
            return ((TableAccessibleHolder)this.owner).getTableAccessible();
        }
        return null;
    }

    @Override
    public SqlNode toSqlNode() {
        if (this.sql != null) {
            return this.sql;
        }
        String column = this.column();
        if (Strings.isBlank(column)) {
            return SqlNodes.EMPTY;
        }
        if (this.expression != null) {
            return this.expression.toSqlNode(column);
        }
        ContainerNode sql = new ContainerNode();
        sql.addNode(new TextNode(column));
        if (this.asc) {
            sql.addNode(SqlNodes.ASC);
        } else {
            sql.addNode(SqlNodes.DESC);
        }
        return sql;
    }

    private String column() {
        if (Strings.isNotBlank(this._rawColumn)) {
            return this._rawColumn;
        }
        if (this.table == null || Strings.isBlank(this.field)) {
            return "";
        }
        this._rawColumn = this.table.getColumnExpression(this.field);
        return this._rawColumn;
    }

    public O end() {
        return this.owner;
    }

    public <T, R> S column(GetterFunction<T, R> getter) {
        return this.column(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public S column(String field) {
        this.field = field;
        return (S)((OrderBySegment)this.getThis());
    }

    public S sql(SqlNode sql) {
        this.sql = sql;
        return (S)((OrderBySegment)this.getThis());
    }

    public S rawColumn(String rawColumn) {
        this._rawColumn = rawColumn = SqlTextParsers.resolveTableRef(rawColumn, this.tableAccessible);
        return (S)((OrderBySegment)this.getThis());
    }

    public O asc() {
        this.asc = true;
        return this.end();
    }

    public O desc() {
        this.asc = false;
        return this.end();
    }

    public S apply(String functionPattern, TableField[] extFields, Map<String, Object> bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField[] extFields, Object ... bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField ... extFields) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields);
    }

    public S apply(String functionPattern) {
        return this.apply((Expression)Expressions.pattern(functionPattern), StdConsts.EMPTY_ARRAY);
    }

    public S apply(String functionPattern, Map<String, Object> bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), bindings);
    }

    public S apply(String functionPattern, Object[] bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), bindings);
    }

    public S apply(Expression function) {
        this.expression = new ExpressionSegment(this.expression, function, StdConsts.EMPTY_ARRAY);
        return (S)((OrderBySegment)this.getThis());
    }

    public S apply(Expression function, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((OrderBySegment)this.getThis());
    }

    public S apply(Expression function, Object[] bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((OrderBySegment)this.getThis());
    }

    public S apply(Expression function, TableField ... extFields) {
        return this.apply(function, extFields, StdConsts.EMPTY_ARRAY);
    }

    public S apply(Expression function, TableField[] extFields, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((OrderBySegment)this.getThis());
    }

    public S apply(Expression function, TableField[] extFields, Object ... bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((OrderBySegment)this.getThis());
    }

    public S apply(String functionPattern, int tableIndex, String field) {
        return this.apply(functionPattern, TableField.of((Integer)tableIndex, field));
    }

    public S apply(Expression function, int tableIndex, String field) {
        return this.apply(function, TableField.of((Integer)tableIndex, field));
    }

    public S apply(String functionPattern, String tableAlias, String field) {
        return this.apply(functionPattern, TableField.of(tableAlias, field));
    }

    public S apply(Expression function, String tableAlias, String field) {
        return this.apply(function, TableField.of(tableAlias, field));
    }

    public S count() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.COUNT.getExpression(), new Object[0]);
        return (S)((OrderBySegment)this.getThis());
    }

    public S sum() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.SUM.getExpression(), new Object[0]);
        return (S)((OrderBySegment)this.getThis());
    }

    public S max() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MAX.getExpression(), new Object[0]);
        return (S)((OrderBySegment)this.getThis());
    }

    public S min() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MIN.getExpression(), new Object[0]);
        return (S)((OrderBySegment)this.getThis());
    }

    public S avg() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.AVG.getExpression(), new Object[0]);
        return (S)((OrderBySegment)this.getThis());
    }

    public TableSegment<?> getTable() {
        return this.table;
    }
}

