/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.collection.Iterables;
import io.polaris.core.consts.StdConsts;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.expression.AggregateFunction;
import io.polaris.core.jdbc.sql.statement.expression.Expression;
import io.polaris.core.jdbc.sql.statement.expression.Expressions;
import io.polaris.core.jdbc.sql.statement.segment.ExpressionSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@AnnotationProcessing
public class SelectSegment<O extends Segment<O>, S extends SelectSegment<O, S>>
extends BaseSegment<S>
implements SqlNodeBuilder,
TableAccessibleHolder {
    private final O owner;
    private final TableSegment<? extends TableSegment<?>> table;
    private final TableAccessible tableAccessible;
    private String field;
    private String alias;
    private String aliasPrefix;
    private String aliasSuffix;
    private SqlNode sql;
    private boolean aliasWithField = true;
    private Object value;
    private ExpressionSegment<?> expression;

    @AnnotationProcessing
    public SelectSegment(O owner, TableSegment<? extends TableSegment<?>> table) {
        this.owner = owner;
        this.table = table;
        this.tableAccessible = this.fetchTableAccessible();
    }

    private TableAccessible fetchTableAccessible() {
        if (this.owner instanceof TableAccessible) {
            return (TableAccessible)this.owner;
        }
        if (this.owner instanceof TableAccessibleHolder) {
            return ((TableAccessibleHolder)this.owner).getTableAccessible();
        }
        return null;
    }

    @Override
    public TableAccessible getTableAccessible() {
        return this.tableAccessible;
    }

    @Override
    public SqlNode toSqlNode() {
        return this.toSqlNode(false);
    }

    static String toAlias(String alias, String aliasPrefix, String aliasSuffix) {
        if (Strings.isBlank(alias)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean startsWith = alias.startsWith("\"");
        boolean endsWith = alias.endsWith("\"");
        if (startsWith) {
            sb.append("\"");
        }
        if (Strings.isNotBlank(aliasPrefix)) {
            sb.append(aliasPrefix);
        }
        sb.append(alias, startsWith ? 1 : 0, endsWith ? alias.length() - 1 : alias.length());
        if (Strings.isNotBlank(aliasSuffix)) {
            sb.append(aliasSuffix);
        }
        if (endsWith) {
            sb.append("\"");
        }
        return sb.toString();
    }

    public SqlNode toSqlNode(boolean quotaAlias) {
        if (this.sql != null) {
            return this.sql;
        }
        String fieldAlias = SelectSegment.toAlias(this.alias, this.aliasPrefix, this.aliasSuffix);
        if (this.value != null && Strings.isNotBlank(fieldAlias)) {
            ContainerNode containerNode = new ContainerNode();
            containerNode.addNode(SqlNodes.dynamic(fieldAlias, this.value));
            if (quotaAlias && !fieldAlias.startsWith("\"")) {
                containerNode.addNode(new TextNode(" \"" + fieldAlias + "\""));
            } else {
                containerNode.addNode(new TextNode(" " + fieldAlias));
            }
            return containerNode;
        }
        if (this.table != null && Strings.isNotBlank(this.field)) {
            if (this.field.equals("*")) {
                if (this.expression != null) {
                    if (Strings.isNotBlank(fieldAlias)) {
                        ContainerNode containerNode = new ContainerNode();
                        containerNode.addNode(this.expression.toSqlNode(this.field));
                        if (quotaAlias && !fieldAlias.startsWith("\"")) {
                            containerNode.addNode(new TextNode(" \"" + fieldAlias + "\""));
                        } else {
                            containerNode.addNode(new TextNode(" " + fieldAlias));
                        }
                        return containerNode;
                    }
                    return this.expression.toSqlNode(this.field);
                }
                return new TextNode(this.table.getAllColumnExpression(this.aliasWithField, quotaAlias, this.aliasPrefix, this.aliasSuffix));
            }
            if (Strings.isBlank(fieldAlias) && this.aliasWithField) {
                fieldAlias = SelectSegment.toAlias(this.field, this.aliasPrefix, this.aliasSuffix);
            }
            String columnExpression = this.table.getColumnExpression(this.field);
            if (this.expression != null) {
                if (Strings.isNotBlank(fieldAlias)) {
                    ContainerNode containerNode = new ContainerNode();
                    containerNode.addNode(this.expression.toSqlNode(columnExpression));
                    if (quotaAlias && !fieldAlias.startsWith("\"")) {
                        containerNode.addNode(new TextNode("  \"" + fieldAlias + "\""));
                    } else {
                        containerNode.addNode(new TextNode(" " + fieldAlias));
                    }
                    return containerNode;
                }
                return this.expression.toSqlNode(columnExpression);
            }
            if (Strings.isNotBlank(fieldAlias)) {
                if (quotaAlias && !fieldAlias.startsWith("\"")) {
                    return new TextNode(columnExpression + "  \"" + fieldAlias + "\"");
                }
                return new TextNode(columnExpression + " " + fieldAlias);
            }
            return new TextNode(columnExpression);
        }
        return SqlNodes.EMPTY;
    }

    public List<String> getSelectRawColumns() {
        if (this.sql != null) {
            return Collections.emptyList();
        }
        if (this.value != null && Strings.isNotBlank(this.alias)) {
            return Iterables.asList(this.alias);
        }
        if (this.table != null && Strings.isNotBlank(this.field)) {
            if (this.expression != null) {
                String fieldAlias = this.alias;
                if (Strings.isBlank(fieldAlias) && this.aliasWithField && !this.field.equals("*")) {
                    fieldAlias = this.field;
                }
                return Iterables.asList(fieldAlias);
            }
            if (this.field.equals("*")) {
                if (this.aliasWithField) {
                    return this.table.getAllFieldNames();
                }
                return this.table.getAllColumnNames();
            }
            String fieldAlias = this.alias;
            if (Strings.isBlank(fieldAlias) && this.aliasWithField) {
                fieldAlias = this.field;
            }
            if (Strings.isNotBlank(fieldAlias)) {
                return Iterables.asList(fieldAlias);
            }
            return Iterables.asList(this.table.getColumnName(this.field));
        }
        return Collections.emptyList();
    }

    public boolean hasSelectRawColumn(String columnOrAlias) {
        if (this.sql != null) {
            return false;
        }
        if (this.value != null && Strings.isNotBlank(this.alias)) {
            return columnOrAlias.equals(this.alias);
        }
        if (this.table != null && Strings.isNotBlank(this.field)) {
            if (this.expression != null) {
                String fieldAlias = this.alias;
                if (Strings.isBlank(fieldAlias) && this.aliasWithField && !this.field.equals("*")) {
                    fieldAlias = this.field;
                }
                return columnOrAlias.equals(fieldAlias);
            }
            if (this.field.equals("*")) {
                if (this.aliasWithField) {
                    return this.table.getAllFieldNames().contains(columnOrAlias);
                }
                return this.table.getAllColumnNames().contains(columnOrAlias);
            }
            String fieldAlias = this.alias;
            if (Strings.isBlank(fieldAlias) && this.aliasWithField) {
                fieldAlias = this.field;
            }
            if (Strings.isNotBlank(fieldAlias)) {
                return columnOrAlias.equals(fieldAlias);
            }
            String columnName = this.table.getColumnName(this.field);
            return columnOrAlias.equals(columnName);
        }
        return false;
    }

    public O end() {
        return this.owner;
    }

    public S apply(String functionPattern, TableField[] extFields, Map<String, Object> bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField[] extFields, Object ... bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField ... extFields) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields);
    }

    public S apply(String functionPattern) {
        return this.apply((Expression)Expressions.pattern(functionPattern), StdConsts.EMPTY_ARRAY);
    }

    public S apply(String functionPattern, Map<String, Object> bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), bindings);
    }

    public S apply(String functionPattern, Object[] bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), bindings);
    }

    public S apply(Expression function) {
        this.expression = new ExpressionSegment(this.expression, function, StdConsts.EMPTY_ARRAY);
        return (S)((SelectSegment)this.getThis());
    }

    public S apply(Expression function, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((SelectSegment)this.getThis());
    }

    public S apply(Expression function, Object[] bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((SelectSegment)this.getThis());
    }

    public S apply(Expression function, TableField ... extFields) {
        return this.apply(function, extFields, StdConsts.EMPTY_ARRAY);
    }

    public S apply(Expression function, TableField[] extFields, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((SelectSegment)this.getThis());
    }

    public S apply(Expression function, TableField[] extFields, Object ... bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((SelectSegment)this.getThis());
    }

    public S apply(String functionPattern, int tableIndex, String field) {
        return this.apply(functionPattern, TableField.of((Integer)tableIndex, field));
    }

    public S apply(Expression function, int tableIndex, String field) {
        return this.apply(function, TableField.of((Integer)tableIndex, field));
    }

    public S apply(String functionPattern, String tableAlias, String field) {
        return this.apply(functionPattern, TableField.of(tableAlias, field));
    }

    public S apply(Expression function, String tableAlias, String field) {
        return this.apply(function, TableField.of(tableAlias, field));
    }

    public O value(Object value, String alias) {
        if (Strings.isEmpty(alias)) {
            throw new IllegalArgumentException("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.value = value;
        return this.alias(alias);
    }

    public S count() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.COUNT.getExpression(), new Object[0]);
        return (S)((SelectSegment)this.getThis());
    }

    public S sum() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.SUM.getExpression(), new Object[0]);
        return (S)((SelectSegment)this.getThis());
    }

    public S max() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MAX.getExpression(), new Object[0]);
        return (S)((SelectSegment)this.getThis());
    }

    public S min() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MIN.getExpression(), new Object[0]);
        return (S)((SelectSegment)this.getThis());
    }

    public S avg() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.AVG.getExpression(), new Object[0]);
        return (S)((SelectSegment)this.getThis());
    }

    public S all() {
        this.field = "*";
        return (S)((SelectSegment)this.getThis());
    }

    public <T, R> S column(GetterFunction<T, R> getter) {
        return this.column(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public S column(String field) {
        this.field = field;
        return (S)((SelectSegment)this.getThis());
    }

    public S aliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
        return (S)((SelectSegment)this.getThis());
    }

    public S aliasSuffix(String aliasSuffix) {
        this.aliasSuffix = aliasSuffix;
        return (S)((SelectSegment)this.getThis());
    }

    public S aliasWithField(boolean withFieldAlias) {
        this.aliasWithField = withFieldAlias;
        return (S)((SelectSegment)this.getThis());
    }

    public O alias(String alias) {
        this.alias = alias;
        return this.end();
    }

    public S sql(SqlNode sql) {
        this.sql = sql;
        return (S)((SelectSegment)this.getThis());
    }
}

