/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.string.Strings;

public interface TableAccessible
extends TableAccessibleHolder {
    public TableSegment<?> getTable(int var1);

    public TableSegment<?> getTable(String var1);

    @Override
    default public TableAccessible getTableAccessible() {
        return this;
    }

    public static TableAccessible of(final TableSegment<?> ... tables) {
        return new TableAccessible(){

            @Override
            public TableSegment<?> getTable(int tableIndex) {
                return tables.length > tableIndex ? tables[tableIndex] : null;
            }

            @Override
            public TableSegment<?> getTable(String tableAlias) {
                for (int i = 0; i < tables.length; ++i) {
                    TableSegment table = tables[i];
                    if (!Strings.equals(table.getTableAlias(), tableAlias)) continue;
                    return table;
                }
                return null;
            }
        };
    }
}

