/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.SetOpsStatement;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableEntitySegment;
import io.polaris.core.jdbc.sql.statement.segment.TableSetViewSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableViewSegment;
import io.polaris.core.string.Strings;
import java.util.List;
import javax.annotation.Nullable;

@AnnotationProcessing
public abstract class TableSegment<S extends TableSegment<S>>
extends BaseSegment<S>
implements SqlNodeBuilder {
    private TableAccessible tableAccessible = new TableAccessible(){

        @Override
        public TableSegment<?> getTable(int tableIndex) {
            if (tableIndex == 0) {
                return TableSegment.this;
            }
            return null;
        }

        @Override
        public TableSegment<?> getTable(String tableAlias) {
            if (Strings.equals(TableSegment.this.getTableAlias(), tableAlias)) {
                return TableSegment.this;
            }
            return null;
        }
    };

    protected TableSegment() {
    }

    public static TableSegment<?> fromEntity(Class<?> entityClass, String alias) {
        return new TableEntitySegment(entityClass, alias);
    }

    public static TableSegment<?> fromSelect(SelectStatement<?> select, String alias) {
        return new TableViewSegment(select, alias);
    }

    public static TableSegment<?> fromSetOps(SetOpsStatement<?> select, String alias) {
        return new TableSetViewSegment(select, alias);
    }

    public abstract SqlNode toSqlNode(boolean var1);

    @Override
    public SqlNode toSqlNode() {
        return this.toSqlNode(true);
    }

    public TableAccessible toTableAccessible() {
        return this.tableAccessible;
    }

    @Nullable
    public TableMeta getTableMeta() {
        return null;
    }

    public abstract String getTableAlias();

    public String getAllColumnExpression(boolean quotaAlias) {
        return this.getAllColumnExpression(true, quotaAlias);
    }

    public String getAllColumnExpression(boolean withTableAlias, boolean quotaAlias) {
        return this.getAllColumnExpression(withTableAlias, false, quotaAlias, "", "");
    }

    public String getAllColumnExpression(boolean aliasWithField, boolean quotaAlias, String aliasPrefix, String aliasSuffix) {
        return this.getAllColumnExpression(true, aliasWithField, quotaAlias, aliasPrefix, aliasSuffix);
    }

    public abstract String getAllColumnExpression(boolean var1, boolean var2, boolean var3, String var4, String var5);

    public String getColumnExpression(String field) {
        return this.getColumnExpression(field, true);
    }

    public abstract String getColumnExpression(String var1, boolean var2);

    public abstract List<String> getAllColumnNames();

    public abstract List<String> getAllFieldNames();

    public abstract String getColumnName(String var1);
}

