/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.string.Strings;
import java.util.List;

public class TableViewSegment<S extends TableViewSegment<S>>
extends TableSegment<S> {
    private final SelectStatement<?> select;
    private final String alias;

    public TableViewSegment(SelectStatement<?> select, String alias) {
        if (Strings.isBlank(alias)) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u5b50\u67e5\u8be2\u522b\u540d");
        }
        this.alias = alias;
        this.select = select;
    }

    @Override
    public SqlNode toSqlNode(boolean withAlias) {
        ContainerNode sql = new ContainerNode();
        sql.addNode(SqlNodes.LEFT_PARENTHESIS);
        sql.addNode(this.select.toSqlNode());
        sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
        if (withAlias) {
            sql.addNode(SqlNodes.BLANK);
            sql.addNode(new TextNode(this.alias));
        }
        return sql;
    }

    @Override
    public SqlNode toSqlNode() {
        return this.toSqlNode(true);
    }

    @Override
    public String getTableAlias() {
        return this.alias;
    }

    @Override
    public String getAllColumnExpression(boolean withTableAlias, boolean aliasWithField, boolean quotaAlias, String aliasPrefix, String aliasSuffix) {
        List<String> selectColumns = this.select.getSelectRawColumns();
        StringBuilder sb = new StringBuilder();
        for (String selectColumn : selectColumns) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (withTableAlias) {
                sb.append(this.alias).append(".").append(selectColumn);
                continue;
            }
            sb.append(selectColumn);
        }
        return sb.toString();
    }

    @Override
    public List<String> getAllColumnNames() {
        return this.select.getSelectRawColumns();
    }

    @Override
    public List<String> getAllFieldNames() {
        return this.select.getSelectRawColumns();
    }

    @Override
    public String getColumnExpression(String field, boolean withTableAlias) {
        if (withTableAlias) {
            return this.alias + "." + this.getColumnName(field);
        }
        return this.getColumnName(field);
    }

    @Override
    public String getColumnName(String field) {
        if (this.select.hasSelectRawColumn(field)) {
            return field;
        }
        throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8868\u5bf9\u5e94\u7684\u5217\u4fe1\u606f\uff1a" + field);
    }
}

