/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.json;

import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.converter.Converters;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.script.Evaluator;
import io.polaris.core.script.ScriptEvaluators;
import io.polaris.core.service.ServiceDefault;
import io.polaris.core.time.Dates;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@ServiceDefault
public class DefaultJsonSerializer
implements JsonSerializer {
    @Override
    public String serialize(Object value) {
        return this._serialize(value).toString();
    }

    private CharSequence _serialize(Object value) {
        try {
            Object val;
            Integer idx;
            String key;
            if (value == null) {
                return "null";
            }
            if (value instanceof TemporalAccessor) {
                return new StringBuilder(22).append(Dates.toDate((TemporalAccessor)value).getTime());
            }
            if (value instanceof Calendar) {
                return new StringBuilder(22).append(((Calendar)value).getTime().getTime());
            }
            if (value instanceof Date) {
                return new StringBuilder(22).append(((Date)value).getTime());
            }
            if (value instanceof BigDecimal) {
                return new StringBuilder(32).append("\"").append(((BigDecimal)value).toPlainString()).append("\"");
            }
            if (value instanceof Long || value instanceof BigInteger || value instanceof AtomicLong) {
                return new StringBuilder(32).append("\"").append(value).append("\"");
            }
            if (value instanceof Number || value instanceof Boolean || value instanceof AtomicBoolean || value.getClass().isPrimitive()) {
                return Objects.toString(value);
            }
            if (value instanceof Character) {
                return new StringBuilder(3).append("\"").append(((Character)value).charValue()).append("\"");
            }
            if (value instanceof CharSequence) {
                String str = value.toString();
                return new StringBuilder(str.length() + 8).append("\"").append(str.replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
            }
            if (value instanceof Enum) {
                String name = ((Enum)value).name();
                return new StringBuilder(name.length() + 2).append("\"").append(name).append("\"");
            }
            StringBuilder sb = new StringBuilder();
            if (value instanceof Map) {
                sb.append("{");
                Set entries = ((Map)value).entrySet();
                Iterator iter = entries.iterator();
                if (iter.hasNext()) {
                    Map.Entry next = iter.next();
                    String str1 = next.getKey().toString();
                    sb.append("\"" + str1.replace("\\", "\\\\").replace("\"", "\\\"") + "\"").append(":").append(this._serialize(next.getValue()));
                    while (iter.hasNext()) {
                        next = iter.next();
                        String str = next.getKey().toString();
                        sb.append(",").append("\"" + str.replace("\\", "\\\\").replace("\"", "\\\"") + "\"").append(":").append(this._serialize(next.getValue()));
                    }
                }
                sb.append("}");
                return sb;
            }
            if (value instanceof Collection) {
                sb.append("[");
                if (value instanceof List && value instanceof RandomAccess) {
                    int size = ((List)value).size();
                    if (size > 0) {
                        sb.append(this._serialize(((List)value).get(0)));
                    }
                    for (int i = 1; i < size; ++i) {
                        Object next = ((List)value).get(i);
                        sb.append(",").append(this._serialize(next));
                    }
                } else {
                    Iterator iter = ((Collection)value).iterator();
                    if (iter.hasNext()) {
                        Object next = iter.next();
                        sb.append(this._serialize(next));
                        while (iter.hasNext()) {
                            next = iter.next();
                            sb.append(",").append(this._serialize(next));
                        }
                    }
                }
                sb.append("]");
                return sb;
            }
            if (value.getClass().isArray()) {
                sb.append("[");
                int len = Array.getLength(value);
                if (len > 0) {
                    sb.append(this._serialize(Array.get(value, 0)));
                    for (int i = 1; i < len; ++i) {
                        sb.append(",").append(this._serialize(Array.get(value, i)));
                    }
                }
                sb.append("]");
                return sb;
            }
            BeanAccess<?> access = BeanAccess.get(value.getClass());
            sb.append("{");
            boolean first = true;
            Map<String, Integer> getterIndices = access.getterIndices();
            for (Map.Entry<String, Integer> entry : getterIndices.entrySet()) {
                key = entry.getKey();
                idx = entry.getValue();
                val = access.getIndexProperty(value, idx);
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("\"" + key.replace("\\", "\\\\").replace("\"", "\\\"") + "\"").append(":").append(this._serialize(val));
            }
            Map<String, Integer> fieldIndices = access.fieldIndices();
            for (Map.Entry<String, Integer> entry : fieldIndices.entrySet()) {
                key = entry.getKey();
                idx = entry.getValue();
                val = access.getIndexField(value, idx);
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("\"" + key.replace("\\", "\\\\").replace("\"", "\\\"") + "\"").append(":").append(this._serialize(val));
            }
            sb.append("}");
            return sb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T deserialize(String json, Type type) {
        try {
            Evaluator engine = ScriptEvaluators.getEvaluator("javascript");
            String content = "JSON.parse(input)";
            Object rs = engine.eval(content, json);
            Object javaObject = this.toJavaObject(rs);
            return Converters.convert(type, javaObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object toJavaObject(Object rs) throws ReflectiveOperationException {
        Boolean isArray;
        if (rs == null) {
            return null;
        }
        Class<?> jsObjectClass = Class.forName("jdk.nashorn.api.scripting.JSObject");
        boolean isJsObject = jsObjectClass.isInstance(rs);
        if (isJsObject && (isArray = (Boolean)jsObjectClass.getMethod("isArray", new Class[0]).invoke(rs, new Object[0])).booleanValue()) {
            Collection values = (Collection)jsObjectClass.getMethod("values", new Class[0]).invoke(rs, new Object[0]);
            ArrayList<Object> list = new ArrayList<Object>(values.size());
            for (Object value : values) {
                list.add(this.toJavaObject(value));
            }
            return list;
        }
        if (rs instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>(((Map)rs).size());
            for (Map.Entry entry : ((Map)rs).entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                map.put(this.toJavaObject(k), this.toJavaObject(v));
            }
            return map;
        }
        if (isJsObject) {
            Set keys = (Set)jsObjectClass.getMethod("keySet", new Class[0]).invoke(rs, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
            for (String key : keys) {
                Object val = jsObjectClass.getMethod("getMember", String.class).invoke(rs, new Object[0]);
                map.put(key, this.toJavaObject(val));
            }
            return map;
        }
        return rs;
    }
}

