/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.json;

import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.service.Service;
import io.polaris.core.service.ServiceLoader;
import io.polaris.core.service.StatefulServiceLoader;
import io.polaris.core.tuple.ValueRef;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;

public class Jsons {
    private static final ILogger log = ILoggers.of(Jsons.class);
    private static volatile ValueRef<JsonSerializer> ref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static JsonSerializer getJsonSerializer() {
        if (ref != null) {
            return ref.get();
        }
        Class<Jsons> clazz = Jsons.class;
        synchronized (Jsons.class) {
            if (ref != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ref.get();
            }
            ref = new ValueRef<JsonSerializer>(Jsons.loadJsonSerializer());
            // ** MonitorExit[var0] (shouldn't be in output)
            return ref.get();
        }
    }

    @Nullable
    private static JsonSerializer loadJsonSerializer() {
        try {
            ServiceLoader<JsonSerializer> serviceLoader = StatefulServiceLoader.load(JsonSerializer.class).serviceLoader();
            List<Service<JsonSerializer>> providers = serviceLoader.getProviders();
            for (Service<JsonSerializer> provider : providers) {
                try {
                    JsonSerializer jsonSerializer = provider.getSingleton();
                    return jsonSerializer;
                }
                catch (Throwable e) {
                    log.error(e, "Failed to load json serializer", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            log.error(e, "Failed to load json serializer", new Object[0]);
        }
        return null;
    }

    public static String serialize(Object value) {
        JsonSerializer jsonSerializer = Jsons.getJsonSerializer();
        if (jsonSerializer != null) {
            return jsonSerializer.serialize(value);
        }
        throw new UnsupportedOperationException();
    }

    public static <T> T deserialize(String json, Type type) {
        JsonSerializer jsonSerializer = Jsons.getJsonSerializer();
        if (jsonSerializer != null) {
            return jsonSerializer.deserialize(json, type);
        }
        throw new UnsupportedOperationException();
    }

    public static <T> T deserialize(String json, Class<? extends T> type) {
        JsonSerializer jsonSerializer = Jsons.getJsonSerializer();
        if (jsonSerializer != null) {
            return jsonSerializer.deserialize(json, type);
        }
        throw new UnsupportedOperationException();
    }

    public static <T> T deserialize(String json, TypeRef<T> type) {
        JsonSerializer jsonSerializer = Jsons.getJsonSerializer();
        if (jsonSerializer != null) {
            return jsonSerializer.deserialize(json, type);
        }
        throw new UnsupportedOperationException();
    }
}

