/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Types {
    private static final Map<Class, Class> primitiveWrapperTypes = new HashMap<Class, Class>();
    private static final Map<Class, Class> wrapperPrimitiveTypes = new HashMap<Class, Class>();
    private static final Map<String, Class> primitiveNameTypes = new HashMap<String, Class>();

    public static Class getPrimitiveClassByName(String type) {
        return primitiveNameTypes.get(type);
    }

    public static Class getPrimitiveClassByWrapper(Class type) {
        return type.isPrimitive() ? type : wrapperPrimitiveTypes.get(type);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isPrimitive();
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return wrapperPrimitiveTypes.containsKey(clazz);
    }

    public static Class<?> getWrapperClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        return primitiveWrapperTypes.getOrDefault(type, type);
    }

    @Nullable
    public static Type getTypeArgument(Type type) {
        return Types.getTypeArgument(type, 0);
    }

    @Nullable
    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = Types.getTypeArguments(type);
        if (typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    @Nonnull
    public static Type[] getTypeArguments(@Nonnull Type type) {
        ParameterizedType parameterizedType = Types.toParameterizedType(type);
        return null == parameterizedType ? new Type[]{} : parameterizedType.getActualTypeArguments();
    }

    @Nullable
    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()).length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = Types.toParameterizedType(genericSuper);
        }
        return result;
    }

    static Map<TypeVariable, Type> _getTypeVariableMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<TypeVariable, Type> typeMap = new HashMap<TypeVariable, Type>();
        while (null != type && null != (parameterizedType = Types.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i], value);
            }
            type = rawType;
        }
        return typeMap;
    }

    public static Map<TypeVariable<?>, Type> getTypeVariableMap(Type type) {
        HashMap typeMap = new HashMap();
        Types.fetchTypeVariableMap(typeMap, type);
        return typeMap;
    }

    private static void fetchTypeVariableMap(Map<TypeVariable<?>, Type> typeMap, Type type) {
        block5: {
            block4: {
                if (!(type instanceof ParameterizedType)) break block4;
                HashMap<String, Type> nameMap = new HashMap<String, Type>();
                Class rawType = (Class)((ParameterizedType)type).getRawType();
                Type[] actualTypes = ((ParameterizedType)type).getActualTypeArguments();
                Type[] variables = rawType.getTypeParameters();
                for (int i = 0; i < variables.length; ++i) {
                    Type value = actualTypes[i];
                    if (!(value instanceof TypeVariable)) {
                        typeMap.put(variables[i], value);
                        nameMap.putIfAbsent(variables[i].getName(), value);
                        continue;
                    }
                    Type existed = typeMap.get(variables[i]);
                    if (existed == null) continue;
                    nameMap.putIfAbsent(variables[i].getName(), existed);
                }
                Type genericSuper = rawType.getGenericSuperclass();
                Types.fetchTypeVariableMap(typeMap, nameMap, genericSuper);
                Type[] genericInterfaces = rawType.getGenericInterfaces();
                for (Type genericInterface : genericInterfaces) {
                    Types.fetchTypeVariableMap(typeMap, nameMap, genericInterface);
                }
                break block5;
            }
            if (!(type instanceof Class)) break block5;
            Types.fetchTypeVariableMap(typeMap, ((Class)type).getGenericSuperclass());
            for (Type genericInterface : ((Class)type).getGenericInterfaces()) {
                Types.fetchTypeVariableMap(typeMap, genericInterface);
            }
        }
    }

    private static void fetchTypeVariableMap(Map<TypeVariable<?>, Type> typeMap, Map<String, Type> nameMap, Type genericInterface) {
        if (genericInterface instanceof ParameterizedType) {
            Class superRawType = (Class)((ParameterizedType)genericInterface).getRawType();
            Type[] superActualTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
            TypeVariable<Class<T>>[] superVariables = superRawType.getTypeParameters();
            for (int i = 0; i < superVariables.length; ++i) {
                Type value = superActualTypes[i];
                if (!(value instanceof TypeVariable)) {
                    typeMap.put(superVariables[i], value);
                    nameMap.putIfAbsent(superVariables[i].getName(), value);
                    continue;
                }
                Type existed = typeMap.get(superVariables[i]);
                if (existed != null) {
                    nameMap.putIfAbsent(superVariables[i].getName(), existed);
                    continue;
                }
                value = nameMap.get(superVariables[i].getName());
                if (value == null) continue;
                typeMap.put(superVariables[i], value);
            }
        }
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<TypeVariable<?>, Type> map = Types.getTypeVariableMap(type);
        Type rs = map.get(typeVariable);
        while (rs instanceof TypeVariable) {
            rs = map.get(rs);
        }
        return rs;
    }

    public static boolean isUnknown(Type type) {
        return type == null || type instanceof TypeVariable;
    }

    @Nonnull
    public static Class<?> getClass(@Nonnull Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            return Object.class;
        }
        if (type instanceof TypeVariable) {
            return Types.getClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length == 1) {
                return Types.getClass(upperBounds[0]);
            }
            return Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            Class<?> componentClass = Types.getClass(componentType);
            return Types.getArrayClass(componentClass);
        }
        return Object.class;
    }

    public static Class<?> getArrayClass(Class componentClass) {
        if (componentClass == Integer.TYPE) {
            return int[].class;
        }
        if (componentClass == Long.TYPE) {
            return long[].class;
        }
        if (componentClass == Byte.TYPE) {
            return byte[].class;
        }
        if (componentClass == Character.TYPE) {
            return char[].class;
        }
        if (componentClass == Boolean.TYPE) {
            return boolean[].class;
        }
        if (componentClass == Short.TYPE) {
            return short[].class;
        }
        if (componentClass == Double.TYPE) {
            return double[].class;
        }
        if (componentClass == Float.TYPE) {
            return float[].class;
        }
        if (componentClass == String.class) {
            return String[].class;
        }
        if (componentClass == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(componentClass, 0).getClass();
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz) {
            return false;
        }
        if (clazz == Optional.class) {
            return Optional.empty();
        }
        if (clazz == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (clazz == OptionalLong.class) {
            return OptionalLong.empty();
        }
        if (clazz == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = Types.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isFunction(Class type) {
        if (type.isInterface()) {
            Method[] methods;
            if (type.isAnnotationPresent(FunctionalInterface.class)) {
                return true;
            }
            int count = 0;
            for (Method method : methods = type.getMethods()) {
                if (method.isDefault() || Modifier.isStatic(method.getModifiers()) || ++count <= 1) continue;
                return false;
            }
            return count == 1;
        }
        return false;
    }

    public static boolean isLambda(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> c = obj.getClass();
        if (!c.getSimpleName().contains("$$Lambda$")) {
            return false;
        }
        if (c.getSuperclass() != Object.class) {
            return false;
        }
        Class<?>[] interfaces = c.getInterfaces();
        if (interfaces.length != 1) {
            return false;
        }
        return Types.isFunction(interfaces[0]);
    }

    public static boolean isEquals(Class<?>[] definedTypes, Class<?>[] checkedTypes) {
        if (definedTypes.length != checkedTypes.length) {
            return false;
        }
        for (int i = 0; i < definedTypes.length; ++i) {
            if (definedTypes[i] == checkedTypes[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> definedType, Class<?> checkedType) {
        if (definedType.isPrimitive()) {
            return definedType == Types.getPrimitiveClassByWrapper(checkedType);
        }
        if (checkedType.isPrimitive()) {
            return Types.getPrimitiveClassByWrapper(definedType) == checkedType;
        }
        return definedType.isAssignableFrom(checkedType);
    }

    public static boolean isAssignable(Class<?>[] definedTypes, Class<?>[] checkedTypes) {
        if (definedTypes.length != checkedTypes.length) {
            return false;
        }
        for (int i = 0; i < definedTypes.length; ++i) {
            if (Types.isAssignable(definedTypes[i], checkedTypes[i])) continue;
            return false;
        }
        return true;
    }

    static {
        primitiveWrapperTypes.put(Integer.TYPE, Integer.class);
        primitiveWrapperTypes.put(Byte.TYPE, Byte.class);
        primitiveWrapperTypes.put(Short.TYPE, Short.class);
        primitiveWrapperTypes.put(Long.TYPE, Long.class);
        primitiveWrapperTypes.put(Character.TYPE, Character.class);
        primitiveWrapperTypes.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperTypes.put(Float.TYPE, Float.class);
        primitiveWrapperTypes.put(Double.TYPE, Double.class);
        primitiveWrapperTypes.forEach((k, v) -> {
            wrapperPrimitiveTypes.put((Class)v, (Class)k);
            primitiveNameTypes.put(k.getName(), (Class)k);
        });
    }
}

