/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.annotation.Alias;
import io.polaris.core.lang.annotation.Annotations;
import io.polaris.core.reflect.Reflects;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AnnotationAttributes {
    private final Map<String, MemberValue> memberValues;
    private final Class<? extends Annotation> annotationType;

    private AnnotationAttributes(Annotation annotation) {
        this.annotationType = annotation.annotationType();
        Method[] methods = AnnotationAttributes.getAnnotationMembers(this.annotationType);
        LinkedHashMap<String, MemberValue> memberValues = new LinkedHashMap<String, MemberValue>();
        for (Method method : methods) {
            String name = method.getName();
            Object value = Reflects.invokeQuietly(annotation, method, new Object[0]);
            memberValues.put(name, new MemberValue(method, value, method.getDefaultValue()));
        }
        for (Method method : methods) {
            MemberValue aliasMemberValue;
            Alias alias = method.getAnnotation(Alias.class);
            if (alias == null || alias.annotation() != this.annotationType && alias.annotation() != Alias.DEFAULT_ANNOTATION) continue;
            String aliasName = alias.value();
            String name = method.getName();
            MemberValue memberValue = (MemberValue)memberValues.get(name);
            Object value = memberValue.getValue();
            if (Objects.equals(value, memberValue.getDefaultValue()) || (aliasMemberValue = (MemberValue)memberValues.get(aliasName)) == null) continue;
            aliasMemberValue.setValue(value);
        }
        this.memberValues = Collections.unmodifiableMap(memberValues);
    }

    private AnnotationAttributes(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        Method[] methods = AnnotationAttributes.getAnnotationMembers(annotationType);
        LinkedHashMap<String, MemberValue> memberValues = new LinkedHashMap<String, MemberValue>();
        for (Method method : methods) {
            String name = method.getName();
            memberValues.put(name, new MemberValue(method, method.getDefaultValue(), method.getDefaultValue()));
        }
        this.memberValues = Collections.unmodifiableMap(memberValues);
    }

    public static <A extends Annotation> AnnotationAttributes of(A annotation) {
        return new AnnotationAttributes(annotation);
    }

    public static <A extends Annotation> AnnotationAttributes of(Class<A> annotationType) {
        return new AnnotationAttributes(annotationType);
    }

    public static <A extends Annotation> Method[] getAnnotationMembers(Class<A> annotationType) {
        Method[] methods = annotationType.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE) continue;
            list.add(method);
        }
        return list.toArray(new Method[0]);
    }

    public Annotation asAnnotation() {
        return Annotations.newInstance(this.annotationType, Collections.unmodifiableMap(this.asMap()));
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.memberValues.forEach((k, v) -> map.put((String)k, v.getValue()));
        return map;
    }

    public Map<String, MemberValue> getMemberValues() {
        return this.memberValues;
    }

    public MemberValue getMemberValue(String name) {
        return this.memberValues.get(name);
    }

    public void set(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public boolean set(String name, Object value) {
        MemberValue memberValue = this.getMemberValue(name);
        if (memberValue != null) {
            return memberValue.setValue(value);
        }
        return false;
    }

    public Object get(String name) {
        MemberValue memberValue = this.getMemberValue(name);
        return memberValue == null ? null : memberValue.getValue();
    }

    public <T> T get(String name, Class<T> type) {
        return Converters.convert(type, this.get(name));
    }

    public String getString(String name) {
        return (String)Converters.convert(String.class, this.get(name));
    }

    public String[] getStringArray(String name) {
        return (String[])Converters.convert(String[].class, this.get(name));
    }

    public Boolean getBoolean(String name) {
        return (Boolean)Converters.convert(Boolean.class, this.get(name));
    }

    public Number getNumber(String name) {
        return (Number)Converters.convert(Number.class, this.get(name));
    }

    public Enum getEnum(String name) {
        return (Enum)Converters.convert(Enum.class, this.get(name));
    }

    public Class getClass(String name) {
        return (Class)Converters.convert(Class.class, this.get(name));
    }

    public Class[] getClassArray(String name) {
        return (Class[])Converters.convert(Class[].class, this.get(name));
    }

    public Annotation getAnnotation(String name) {
        return (Annotation)Converters.convert(Annotation.class, this.get(name));
    }

    public Annotation[] getAnnotationArray(String name) {
        return (Annotation[])Converters.convert(Annotation[].class, this.get(name));
    }

    public AnnotationAttributes getAnnotationAttributes(String name) {
        return AnnotationAttributes.of(this.getAnnotation(name));
    }

    public AnnotationAttributes[] getAnnotationAttributesArray(String name) {
        Annotation[] arr = this.getAnnotationArray(name);
        AnnotationAttributes[] attributes = new AnnotationAttributes[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            attributes[i] = AnnotationAttributes.of(arr[i]);
        }
        return attributes;
    }

    public <V extends Annotation> V getAnnotation(String name, Class<V> annotationType) {
        return (V)((Annotation)Converters.convert(annotationType, this.get(name)));
    }

    public <V extends Annotation> AnnotationAttributes getAnnotationAttributes(String name, Class<V> annotationType) {
        Annotation a = (Annotation)Converters.convert(annotationType, this.get(name));
        return AnnotationAttributes.of(a);
    }

    public <V extends Annotation> V[] getAnnotationArray(String name, Class<V> annotationType) {
        return (Annotation[])Converters.convert(Array.newInstance(annotationType, 0).getClass(), this.get(name));
    }

    public <V extends Annotation> AnnotationAttributes[] getAnnotationAttributesArray(String name, Class<V> annotationType) {
        Annotation[] arr = (Annotation[])Converters.convert(Array.newInstance(annotationType, 0).getClass(), this.get(name));
        AnnotationAttributes[] attributes = new AnnotationAttributes[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            attributes[i] = AnnotationAttributes.of(arr[i]);
        }
        return attributes;
    }

    public static class MemberValue {
        private Method method;
        private Object value;
        private Object defaultValue;

        public boolean setValue(Object value) {
            if (value == null || value.equals(this.defaultValue)) {
                return false;
            }
            Object o = Converters.convertQuietly(this.method.getGenericReturnType(), value);
            if (o != null) {
                this.value = o;
                return true;
            }
            return false;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public MemberValue(Method method, Object value, Object defaultValue) {
            this.method = method;
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return "AnnotationAttributes.MemberValue(method=" + this.method + ", value=" + this.value + ", defaultValue=" + this.defaultValue + ")";
        }
    }
}

