/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.BeanMapOptions;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class BeanDelegateMap<T>
extends BeanMap<T> {
    private static final ILogger log = ILoggers.of(BeanDelegateMap.class);
    protected final Map<String, Object> raw;

    public BeanDelegateMap(T raw, Class<?> beanType, BeanMapOptions options) {
        super(raw, beanType, options);
        this.raw = (Map)raw;
    }

    @Override
    public <V> V copyToBean(V bean) {
        BeanMap<V> map = Beans.newBeanMap(bean);
        map.putAll(this.raw);
        return map.getBean();
    }

    @Override
    public Map<String, Object> copyToMap(Map<String, Object> map) {
        map.putAll(this.raw);
        return map;
    }

    @Override
    public Map<String, Object> copyToMap() {
        return this.copyToMap(new HashMap<String, Object>());
    }

    @Override
    public Type getType(String key) {
        return Object.class;
    }

    @Override
    public Object get(Object key) {
        return this.raw.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.raw.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.raw.putAll(m);
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.raw.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.raw.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.raw.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.raw.containsValue(value);
    }

    @Override
    public Object remove(Object key) {
        return this.raw.remove(key);
    }

    @Override
    public void clear() {
        this.raw.clear();
    }
}

