/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.BeanMapOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class BeanIndexedMap<T>
extends BeanMap<T> {
    private static final ILogger log = ILoggers.of(BeanIndexedMap.class);
    private final BeanAccess<?> access;
    private final Map<String, Integer> setterIndices;
    private final Map<String, Integer> getterIndices;
    private final int fieldStartIndex;
    private transient Set<Map.Entry<String, Object>> entrySet;
    private transient Collection<Object> values;

    BeanIndexedMap(T bean, Class<?> beanType, BeanMapOptions options) {
        super(bean, beanType, options);
        BeanAccess<?> access = BeanAccess.get(beanType);
        this.access = access;
        if (this.includeFields) {
            Map<String, Integer> setterIndices = access.setterIndices();
            Map<String, Integer> getterIndices = access.getterIndices();
            Map<String, Integer> fieldIndices = access.fieldIndices();
            this.fieldStartIndex = Integer.max(setterIndices.size(), getterIndices.size());
            HashMap<String, Integer> setterIndicesTmp = new HashMap<String, Integer>(setterIndices.size() + fieldIndices.size());
            HashMap<String, Integer> getterIndicesTmp = new HashMap<String, Integer>(getterIndices.size() + fieldIndices.size());
            setterIndicesTmp.putAll(setterIndices);
            getterIndicesTmp.putAll(getterIndices);
            for (Map.Entry<String, Integer> entry : fieldIndices.entrySet()) {
                setterIndicesTmp.put(entry.getKey(), this.fieldStartIndex + entry.getValue());
                getterIndicesTmp.put(entry.getKey(), this.fieldStartIndex + entry.getValue());
            }
            this.setterIndices = Collections.unmodifiableMap(setterIndicesTmp);
            this.getterIndices = Collections.unmodifiableMap(getterIndicesTmp);
        } else {
            this.setterIndices = access.setterIndices();
            this.getterIndices = access.getterIndices();
            this.fieldStartIndex = 0;
        }
    }

    @Override
    public Type getType(String key) {
        return this.access.propertyGenericType(key);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            Integer idx = this.getterIndices.get((String)key);
            if (idx != null) {
                if (idx < this.fieldStartIndex) {
                    return this.access.getIndexProperty(this.bean, idx);
                }
                return this.access.getIndexField(this.bean, idx - this.fieldStartIndex);
            }
            if (this.hasFallbackGetter) {
                return this.options.fallbackGetter().apply((String)key);
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Integer idx = this.setterIndices.get(key);
        if (idx != null) {
            block9: {
                try {
                    if (this.hasConverter && value != null) {
                        Type type = this.access.propertyGenericType(key);
                        value = this.options.converter().apply(type, value);
                    }
                    if (idx < this.fieldStartIndex) {
                        this.access.setIndexProperty(this.bean, idx, value);
                    } else {
                        this.access.setIndexField(this.bean, idx - this.fieldStartIndex, value);
                    }
                }
                catch (Exception e) {
                    if (this.ignoreError) break block9;
                    throw new IllegalArgumentException("\u5c5e\u6027\u5199\u5165\u5931\u8d25\uff1a" + this.beanType.getCanonicalName() + "." + key, e);
                }
            }
            return null;
        }
        if (this.hasFallbackSetter) {
            this.options.fallbackSetter().accept(key, value);
            return null;
        }
        if (!this.ignoreUnknownKeys) {
            throw new IllegalArgumentException("\u672a\u77e5\u5c5e\u6027\uff1a" + key);
        }
        if (this.warnUnknownKeys) {
            log.warn("\u672a\u77e5\u5c5e\u6027\uff1a{}.{}", this.beanType.getCanonicalName(), key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public int size() {
        return this.getterIndices.size();
    }

    @Override
    public boolean isEmpty() {
        return this.getterIndices.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getterIndices.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.getterIndices.keySet();
    }

    @Override
    public Collection<Object> values() {
        InnerValues vs = this.values;
        if (vs == null) {
            this.values = vs = new InnerValues();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        InnerEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new InnerEntrySet()) : es;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<String, Integer> entry : this.getterIndices.entrySet()) {
            Integer idx = entry.getValue();
            Object obj = idx < this.fieldStartIndex ? this.access.getIndexProperty(this.bean, idx) : this.access.getIndexField(this.bean, idx - this.fieldStartIndex);
            if (!Objs.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    final class InnerEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        InnerEntrySet() {
        }

        @Override
        public int size() {
            return BeanIndexedMap.this.size();
        }

        @Override
        public void clear() {
            BeanIndexedMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                private final Set<Map.Entry<String, Integer>> entrySet;
                private final Iterator<Map.Entry<String, Integer>> it;
                {
                    this.entrySet = BeanIndexedMap.this.getterIndices.entrySet();
                    this.it = this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    final Map.Entry<String, Integer> next = this.it.next();
                    return new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return (String)next.getKey();
                        }

                        @Override
                        public Object getValue() {
                            Integer idx = (Integer)next.getValue();
                            if (idx < BeanIndexedMap.this.fieldStartIndex) {
                                return BeanIndexedMap.this.access.getIndexProperty(BeanIndexedMap.this.bean, idx);
                            }
                            return BeanIndexedMap.this.access.getIndexField(BeanIndexedMap.this.bean, idx - BeanIndexedMap.this.fieldStartIndex);
                        }

                        @Override
                        public Object setValue(Object value) {
                            return BeanIndexedMap.this.put((String)next.getKey(), value);
                        }
                    };
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            if (!BeanIndexedMap.this.containsKey(key)) {
                return false;
            }
            Object val = BeanIndexedMap.this.get(key);
            return Objs.equals(val, e.getValue());
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    final class InnerValues
    extends AbstractCollection<Object> {
        InnerValues() {
        }

        @Override
        public final int size() {
            return BeanIndexedMap.this.size();
        }

        @Override
        public final void clear() {
            BeanIndexedMap.this.clear();
        }

        @Override
        public final Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private Set<Map.Entry<String, Integer>> entrySet;
                private Iterator<Map.Entry<String, Integer>> it;
                {
                    this.entrySet = BeanIndexedMap.this.getterIndices.entrySet();
                    this.it = this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Object next() {
                    Map.Entry<String, Integer> next = this.it.next();
                    Integer idx = next.getValue();
                    if (idx < BeanIndexedMap.this.fieldStartIndex) {
                        return BeanIndexedMap.this.access.getIndexProperty(BeanIndexedMap.this.bean, idx);
                    }
                    return BeanIndexedMap.this.access.getIndexField(BeanIndexedMap.this.bean, idx - BeanIndexedMap.this.fieldStartIndex);
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            return BeanIndexedMap.this.containsValue(o);
        }
    }
}

