/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.BeanAccessMode;
import io.polaris.core.lang.bean.BeanDelegateMap;
import io.polaris.core.lang.bean.BeanIndexedMap;
import io.polaris.core.lang.bean.BeanLambdaMap;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.BeanMapOptions;
import java.util.Map;

public class BeanMapBuilder<T> {
    private T bean;
    private Class<?> beanType;
    private BeanMapOptions options = new BeanMapOptions();

    public BeanMapBuilder(T bean) {
        this.bean = bean;
    }

    public static <T> BeanMapBuilder<T> of(T bean) {
        return new BeanMapBuilder<T>(bean);
    }

    public BeanMap<T> build() {
        if (this.bean == null) {
            throw new IllegalArgumentException("bean is null");
        }
        Class<?> beanType = this.beanType;
        if (beanType == null) {
            beanType = this.bean.getClass();
        }
        if (Map.class.isAssignableFrom(beanType)) {
            return new BeanDelegateMap<T>(this.bean, beanType, this.options);
        }
        if (beanType.isArray() || beanType.isPrimitive() || Types.isPrimitiveWrapper(beanType)) {
            throw new IllegalArgumentException("unsupported bean type");
        }
        BeanMapOptions options = this.options == null ? new BeanMapOptions() : this.options;
        BeanAccessMode mode = options.mode() == null ? BeanAccessMode.INDEXED : options.mode();
        switch (mode) {
            case LAMBDA: {
                return new BeanLambdaMap<T>(this.bean, beanType, options);
            }
        }
        return new BeanIndexedMap<T>(this.bean, beanType, options);
    }

    public BeanMapBuilder<T> bean(T bean) {
        this.bean = bean;
        return this;
    }

    public BeanMapBuilder<T> beanType(Class<?> beanType) {
        this.beanType = beanType;
        return this;
    }

    public BeanMapBuilder<T> options(BeanMapOptions options) {
        this.options = options;
        return this;
    }

    public T bean() {
        return this.bean;
    }

    public Class<?> beanType() {
        return this.beanType;
    }

    public BeanMapOptions options() {
        return this.options;
    }
}

