/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.lang.bean.PropertyAccessor;
import java.lang.reflect.Type;

class PropertyFieldIndexedAccessor
implements PropertyAccessor {
    private final BeanAccess<?> access;
    private final Type type;
    private final int index;

    PropertyFieldIndexedAccessor(BeanAccess<?> access, Type type, int index) {
        assert (index >= 0);
        this.access = access;
        this.type = type;
        this.index = index;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean hasSetter() {
        return true;
    }

    @Override
    public boolean hasGetter() {
        return true;
    }

    @Override
    public Object get(Object bean) {
        return this.access.getIndexField(bean, this.index);
    }

    @Override
    public void set(Object bean, Object val) {
        this.access.setIndexField(bean, this.index, val);
    }
}

