/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.asm.reflect.BeanCopier;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.copier.BeanToBeanCopier;
import io.polaris.core.lang.copier.BeanToMapCopier;
import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.lang.copier.MapToBeanCopier;
import io.polaris.core.lang.copier.MapToMapCopier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class Copiers {
    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target) {
        return Copiers.fastCopy(source, source.getClass(), target, target.getClass());
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target, @Nonnull Type targetType) {
        return Copiers.fastCopy(source, source.getClass(), target, targetType);
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull Type sourceType, @Nonnull E target, @Nonnull Type targetType) {
        if (source instanceof Map) {
            if (target instanceof Map) {
                ((Map)target).putAll((Map)source);
            } else {
                BeanCopier.get(JavaType.of(targetType).getRawClass()).copyMapToBean((Map)source, target);
            }
        } else if (target instanceof Map) {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToMap(source, (Map)target);
        } else {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToBean(source, JavaType.of(targetType).getRawClass(), target);
        }
        return target;
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target, @Nonnull CopyOptions options) {
        return Copiers.fastCopy(source, source.getClass(), target, target.getClass(), options);
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull E target, @Nonnull Type targetType, @Nonnull CopyOptions options) {
        return Copiers.fastCopy(source, source.getClass(), target, targetType, options);
    }

    public static <E> E fastCopy(@Nonnull Object source, @Nonnull Type sourceType, @Nonnull E target, @Nonnull Type targetType, @Nonnull CopyOptions options) {
        if (source instanceof Map) {
            if (target instanceof Map) {
                new MapToMapCopier((Map)source, targetType, (Map)target, options).copy();
            } else {
                BeanCopier.get(JavaType.of(targetType).getRawClass()).copyMapToBean((Map<String, Object>)((Map)source), target, options);
            }
        } else if (target instanceof Map) {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToMap(source, (Map)target, options);
        } else {
            BeanCopier.get(JavaType.of(sourceType).getRawClass()).copyBeanToBean(source, JavaType.of(targetType).getRawClass(), target, options);
        }
        return target;
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull S source, @Nonnull Map<String, Object> target) {
        return Copiers.fastCopyBeanToMap(source.getClass(), source, target);
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Map<String, Object> target) {
        BeanCopier.get(sourceType).copyBeanToMap(source, target);
        return target;
    }

    public static <S, K, V> Map<K, V> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, BiFunction<Type, Object, Object> converter) {
        BeanCopier.get(sourceType).copyBeanToMap(source, targetType, target, converter);
        return target;
    }

    public static <S> Map<String, Object> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Map<String, Object> target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToMap(source, target, options);
        return target;
    }

    public static <S, K, V> Map<K, V> fastCopyBeanToMap(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToMap(source, targetType, target, options);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target) {
        Copiers.fastCopyMapToBean(source, target.getClass(), target);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target) {
        BeanCopier.get(targetType).copyMapToBean(source, target);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target, BiFunction<Type, Object, Object> converter) {
        return (T)Copiers.fastCopyMapToBean(source, target.getClass(), target, converter);
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target, BiFunction<Type, Object, Object> converter) {
        BeanCopier.get(targetType).copyMapToBean(source, target, converter);
        return target;
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull T target, @Nonnull CopyOptions options) {
        return (T)Copiers.fastCopyMapToBean(source, target.getClass(), target, options);
    }

    public static <T> T fastCopyMapToBean(@Nonnull Map<String, Object> source, @Nonnull Class<T> targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanCopier.get(targetType).copyMapToBean(source, target, options);
        return target;
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull S source, @Nonnull T target) {
        return (T)Copiers.fastCopyBeanToBean(source.getClass(), source, target.getClass(), target);
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Class<T> targetType, @Nonnull T target) {
        BeanCopier.get(sourceType).copyBeanToBean(source, targetType, target);
        return target;
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        return (T)Copiers.fastCopyBeanToBean(source.getClass(), source, target.getClass(), target, options);
    }

    public static <S, T> T fastCopyBeanToBean(@Nonnull Class<S> sourceType, @Nonnull S source, @Nonnull Class<T> targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanCopier.get(sourceType).copyBeanToBean(source, targetType, target, options);
        return target;
    }

    public static Map copyMapToMap(@Nonnull Map source, @Nonnull Map target, @Nonnull CopyOptions options) {
        MapToMapCopier copier = new MapToMapCopier(source, new TypeRef<Map<String, Object>>(){}.getType(), target, options);
        copier.copy();
        return target;
    }

    public static Map copyMapToMap(@Nonnull Map source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        MapToMapCopier copier = new MapToMapCopier(source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <S> Map copyBeanToMap(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        BeanToMapCopier<S> copier = new BeanToMapCopier<S>(sourceType, source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <S> Map copyBeanToMap(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Map target, @Nonnull CopyOptions options) {
        BeanToMapCopier<S> copier = new BeanToMapCopier<S>(sourceType, source, new TypeRef<Map<String, Object>>(){}.getType(), target, options);
        copier.copy();
        return target;
    }

    public static <S> Map copyBeanToMap(@Nonnull S source, @Nonnull Type targetType, @Nonnull Map target, @Nonnull CopyOptions options) {
        BeanToMapCopier<S> copier = new BeanToMapCopier<S>(source.getClass(), source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <S> Map copyBeanToMap(@Nonnull S source, @Nonnull Map target, @Nonnull CopyOptions options) {
        BeanToMapCopier<S> copier = new BeanToMapCopier<S>(source.getClass(), source, new TypeRef<Map<String, Object>>(){}.getType(), target, options);
        copier.copy();
        return target;
    }

    public static <T> T copyMapToBean(@Nonnull Map source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        MapToBeanCopier<T> copier = new MapToBeanCopier<T>(source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <T> T copyMapToBean(@Nonnull Map source, @Nonnull T target, @Nonnull CopyOptions options) {
        MapToBeanCopier<T> copier = new MapToBeanCopier<T>(source, target.getClass(), target, options);
        copier.copy();
        return target;
    }

    public static <S, T> T copyBeanToBean(@Nonnull Type sourceType, @Nonnull S source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanToBeanCopier<S, T> copier = new BeanToBeanCopier<S, T>(sourceType, source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <S, T> T copyBeanToBean(@Nonnull S source, @Nonnull Type targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanToBeanCopier<S, T> copier = new BeanToBeanCopier<S, T>(source.getClass(), source, targetType, target, options);
        copier.copy();
        return target;
    }

    public static <S, T> T copyBeanToBean(@Nonnull Type sourceType, @Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanToBeanCopier<S, T> copier = new BeanToBeanCopier<S, T>(sourceType, source, target.getClass(), target, options);
        copier.copy();
        return target;
    }

    public static <S, T> T copyBeanToBean(@Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        BeanToBeanCopier<S, T> copier = new BeanToBeanCopier<S, T>(source.getClass(), source, target.getClass(), target, options);
        copier.copy();
        return target;
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, null).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, options).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, targetType, target, null).copy();
    }

    public static <E> E copy(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, targetType, target, options).copy();
    }

    public static <E> E copy(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull E target, @Nonnull Type targetType, CopyOptions options) {
        return Copiers.create(sourceType, source, targetType, target, options).copy();
    }

    public static <E> Copier<E> create(@Nonnull Type sourceType, @Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        Copier<Object> copier = source instanceof Map ? (target instanceof Map ? new MapToMapCopier((Map)source, targetType, (Map)target, options) : new MapToBeanCopier<E>((Map)source, targetType, target, options)) : (target instanceof Map ? new BeanToMapCopier<Object>(sourceType, source, targetType, (Map)target, options) : new BeanToBeanCopier<Object, E>(sourceType, source, targetType, target, options));
        return copier;
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, null);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, target.getClass(), target, options);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target) {
        return Copiers.create(source.getClass(), source, targetType, target, null);
    }

    public static <E> Copier<E> create(@Nonnull Object source, @Nonnull Type targetType, @Nonnull E target, CopyOptions options) {
        return Copiers.create(source.getClass(), source, targetType, target, options);
    }
}

