/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.lang.Numbers;
import io.polaris.core.random.Randoms;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Doubles {
    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(double[] array) {
        return !Doubles.isEmpty(array);
    }

    public static double[] join(double[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (double[] array : arrays) {
            if (!Doubles.isNotEmpty(array)) continue;
            length += array.length;
        }
        double[] result = new double[length];
        length = 0;
        for (double[] array : arrays) {
            if (!Doubles.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int indexOf(double[] array, double value) {
        if (Doubles.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!Numbers.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        if (Doubles.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!Numbers.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(double[] array, double value) {
        return Doubles.indexOf(array, value) > -1;
    }

    public static Double[] wrap(double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Double[0];
        }
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unwrap(Double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new double[0];
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(0.0);
        }
        return array;
    }

    public static double[] sub(double[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new double[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new double[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static double[] remove(double[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        double[] result = new double[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static double[] removeElement(double[] array, double element) throws IllegalArgumentException {
        return Doubles.remove(array, Doubles.indexOf(array, element));
    }

    public static double[] reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Doubles.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Doubles.swap(array, i, j);
        }
        return array;
    }

    public static double[] reverse(double[] array) {
        return Doubles.reverse(array, 0, array.length);
    }

    public static double min(double ... numberArray) {
        if (Doubles.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double max(double ... numberArray) {
        if (Doubles.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static double[] shuffle(double[] array) {
        return Doubles.shuffle(array, Randoms.getRandom());
    }

    public static double[] shuffle(double[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Doubles.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static double[] swap(double[] array, int index1, int index2) {
        if (Doubles.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static boolean isSorted(double[] array) {
        return Doubles.isSortedAsc(array);
    }

    public static boolean isSortedAsc(double[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(double[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }
}

