/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.classloader.ClassLoaders;
import io.polaris.core.env.GlobalStdEnv;
import io.polaris.core.log.ILogResolver;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.support.DynamicSlf4jAwareLogger;
import io.polaris.core.log.support.DynamicSlf4jLogger;
import io.polaris.core.log.support.Slf4jAwareLogger;
import io.polaris.core.log.support.Slf4jLogger;
import io.polaris.core.log.support.StdoutLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class DynamicLoggerResolver
implements ILogResolver {
    public static final String PREFER_DYNAMIC_SLF4J = DynamicLoggerResolver.class.getName() + ".prefer-dynamic-slf4j";
    private final Map<String, ILogger> CACHE = new ConcurrentHashMap<String, ILogger>();
    private volatile long lastLoaderChangeId = ClassLoaders.INSTANCE.changeId();
    private final boolean preferDynamicSlf4j = GlobalStdEnv.getBoolean(PREFER_DYNAMIC_SLF4J, false);

    @Override
    public ILogger getLogger(String name) {
        if (ClassLoaders.INSTANCE.changeId() != this.lastLoaderChangeId) {
            this.lastLoaderChangeId = ClassLoaders.INSTANCE.changeId();
            this.CACHE.clear();
        }
        return this.CACHE.computeIfAbsent(name, k -> this.newLogger(name));
    }

    private ILogger newLogger(String name) {
        ILogger logger = null;
        if (this.preferDynamicSlf4j && (logger = DynamicLoggerResolver.getDynamicSlf4jLogger(name)) != null) {
            return logger;
        }
        logger = DynamicLoggerResolver.getDirectSlf4jLogger(name);
        if (logger != null) {
            return logger;
        }
        if (!this.preferDynamicSlf4j && (logger = DynamicLoggerResolver.getDynamicSlf4jLogger(name)) != null) {
            return logger;
        }
        return new StdoutLogger(name);
    }

    private static ILogger getDynamicSlf4jLogger(String name) {
        try {
            Class<?> classLoggerFactory = ClassLoaders.INSTANCE.loadClass("org.slf4j.LoggerFactory");
            Class<?> classLogger = ClassLoaders.INSTANCE.loadClass("org.slf4j.Logger");
            Class<?> classLocationAwareLogger = ClassLoaders.INSTANCE.loadClass("org.slf4j.spi.LocationAwareLogger");
            Class<?> classMarker = ClassLoaders.INSTANCE.loadClass("org.slf4j.Marker");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(classLogger, new Class[]{String.class});
            MethodHandle handle = lookup.findStatic(classLoggerFactory, "getLogger", methodType);
            Object logger = handle.invokeWithArguments(name);
            if (classLocationAwareLogger.isInstance(logger)) {
                return new DynamicSlf4jAwareLogger(classLocationAwareLogger, classMarker, logger);
            }
            return new DynamicSlf4jLogger(classLogger, logger);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ILogger getDirectSlf4jLogger(String name) {
        try {
            Logger logger = LoggerFactory.getLogger((String)name);
            if (logger instanceof LocationAwareLogger) {
                return new Slf4jAwareLogger((LocationAwareLogger)logger);
            }
            return new Slf4jLogger(logger);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

