/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.function.ConsumerWithArgs4;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.Level;
import io.polaris.core.string.Strings;
import io.polaris.core.time.Dates;
import java.time.Instant;

public class StdoutLogger
implements ILogger {
    private final String name;
    private final Level level;
    private ConsumerWithArgs4<Level, String, Object[], Throwable> printer;

    public StdoutLogger(String name) {
        Level level;
        this.name = name;
        try {
            String levelStr = System.getProperty("logger.level." + name);
            level = Level.valueOf(Strings.coalesce(levelStr, Level.DEBUG.name()).toLowerCase());
        }
        catch (Throwable e) {
            level = Level.DEBUG;
        }
        this.level = level;
    }

    public StdoutLogger(String name, Level level, ConsumerWithArgs4<Level, String, Object[], Throwable> printer) {
        this.name = name;
        this.level = level;
        this.printer = printer;
    }

    private void print(Level level, String msg, Object[] arguments, Throwable t) {
        if (this.level.ordinal() > level.ordinal()) {
            return;
        }
        if (this.printer != null) {
            this.printer.accept(level, msg, arguments, t);
            return;
        }
        String delimiter = " ";
        long tid = Thread.currentThread().getId();
        if (arguments != null && arguments.length > 0) {
            System.out.println(Dates.YYYY_MM_DD_HH_MM_SS_SSS.format(Instant.now()) + delimiter + (Object)((Object)level) + delimiter + "[" + tid + "]" + delimiter + this.name + delimiter + Strings.format(msg, arguments));
        } else {
            System.out.println(Dates.YYYY_MM_DD_HH_MM_SS_SSS.format(Instant.now()) + delimiter + (Object)((Object)level) + delimiter + "[" + tid + "]" + delimiter + this.name + delimiter + msg);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level.ordinal() <= Level.TRACE.ordinal();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level.ordinal() <= Level.DEBUG.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level.ordinal() <= Level.INFO.ordinal();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level.ordinal() <= Level.WARN.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level.ordinal() <= Level.ERROR.ordinal();
    }

    @Override
    public void trace(String msg) {
        this.trace(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        this.print(Level.TRACE, msg, arguments, t);
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        this.print(Level.DEBUG, msg, arguments, t);
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        this.print(Level.INFO, msg, arguments, t);
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        this.print(Level.WARN, msg, arguments, t);
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        this.print(Level.ERROR, msg, arguments, t);
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

