/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.map.TransformMap;
import io.polaris.core.string.StringCases;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class CaseCamelMap<K, V>
extends TransformMap<K, V> {
    private static final Function TRANSFORMER = key -> key instanceof CharSequence ? StringCases.underlineToCamelCase((CharSequence)key) : key;

    public CaseCamelMap(Supplier<Map<K, V>> supplier) {
        super(supplier, TRANSFORMER);
    }

    public CaseCamelMap() {
        super(new LinkedHashMap(), TRANSFORMER);
    }

    public CaseCamelMap(Supplier<Map<K, V>> supplier, Map<K, V> raw) {
        this(supplier);
        super.addRawData(raw);
    }

    public CaseCamelMap(Map<K, V> raw) {
        this();
        super.addRawData(raw);
    }

    private void addRawData(Map<K, V> raw) {
        for (Map.Entry<K, V> entry : raw.entrySet()) {
            this.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }
}

